% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hwsd.R
\name{ini_hwsd2}
\alias{ini_hwsd2}
\title{Download and Setup HWSD v2.0 Data Files to Extract their Data Offline}
\usage{
ini_hwsd2(data_path = "./data/", timeout = 300)
}
\arguments{
\item{data_path}{String specifying the directory path where HWSD v2.0 data files are stored or should be downloaded (default is './data/').}

\item{timeout}{Timeout in seconds for downloading each HWSD v2.0 data file (default is 300).}
}
\value{
A list object (`con`) containing two items: 
  - `raster`: HWSDv2 raster object for spatial queries.
  - `sqlite`: Connection to the HWSDv2 SQLite database.
}
\description{
Downloads and sets up the HWSD v2.0 data files required to extract soil data offline. The function
retrieves the HWSD raster soil unit map and the SQLite database containing soil attributes. If the files 
already exist in the specified directory, they are used directly. The function returns an object with 
the raster and SQLite connection for further queries.
}
\examples{
if (interactive()) {
  hwsd2 <- ini_hwsd2(data_path = 'C:/Users/Kel-shamaa/Downloads/HWSD v2/')
}
 
}
\seealso{
\code{\link{get_hwsd2}}
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
