% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EQF.permu.R
\name{EQF.permu}
\alias{EQF.permu}
\title{EQF Permutation}
\usage{
EQF.permu(
  LOD.QTLdetect.result,
  ptime = 1000,
  alpha = 0.05,
  Q = TRUE,
  console = TRUE
)
}
\arguments{
\item{LOD.QTLdetect.result}{list. The data list of the output from
LOD.QTLdetect().}

\item{ptime}{integer. The permutation times.}

\item{alpha}{numeric. The type 1 error rate of detecting the hotspot.}

\item{Q}{logical. When set to TRUE, the function will additionally carry
out the population of the Q method as the control group, which will be
indicated as 'B' in the output.}

\item{console}{logical. Determines whether the process of the algorithm
will be displayed in the R console or not.}
}
\value{
\item{EQF.matrix}{The matrix denotes the EQF value of each bin.}
\item{bin}{The bin information matrix used in this analysis.}
\item{LOD.threshole}{The LOD threshold used in this analysis.}
\item{cluster.number}{The number of QTLs in each cluster group.}
\item{cluster.id}{The serial number of traits in each cluster group.}
\item{cluster.matrix}{The new EQF matrix from the clustering process.}
\item{permu.matrix.cluster}{The permutation result of the clustering
method, which has been sorted by order.}
\item{permu.matrix.Q}{The permutation result of the Q method, which has
been sorted by order.}
\item{EQF.threshold}{The EQF threshold is calculated from the
permutation process.}
}
\description{
The EQF matrix cluster permutation process for QTL hotspot detection.
}
\examples{
# load the example data
load(system.file("extdata", "LODexample.RDATA", package = "QTLEMM"))

# run and result
result <- EQF.permu(LOD.QTLdetect.result, ptime = 50)
result$cluster.number
}
\references{
Wu, P.-Y., M.-.H. Yang, and C.-H. KAO 2021 A Statistical Framework
for QTL Hotspot Detection. G3: Genes, Genomes, Genetics: jkab056.
}
\seealso{
\code{\link[QTLEMM]{LOD.QTLdetect}}
\code{\link[QTLEMM]{EQF.plot}}
}
