% Generated by roxygen2 (4.0.2): do not edit by hand
\name{qualval}
\alias{qualval}
\title{Test for qualitative interactions from estimation}
\usage{
qualval(effect, se, test = c("IBGA", "LRT"), alpha = 0.05,
  plotout = FALSE)
}
\arguments{
\item{effect}{treatment effects. A numeric vector as the estimated (for pvalue) or
designed (for power) treatment effects for different patient subgroups.}

\item{se}{standard error of estimated treatmen effects. A numeric vector as the
standard error for the estimated treatment effects.}

\item{test}{testing method. Choose either \code{"IBGA"} (interval based graphical
approach) or \code{"LRT"} (Gail Simon likelihood ratio test).}

\item{alpha}{significance level. The type I error for qualitative
interaction tesing. The default is 0.05.}

\item{plotout}{whether output the plot or not for \code{test = "IBGA"}.
There is no plot output for \code{test = "LRT"}.}
}
\value{
An object with S3 class "qualint".
\item{call}{the call that produces this object.}
\item{n}{the sample size for each treatment in each subgroup.}
\item{type}{response type.}
\item{alpha}{significance level for the test.}
\item{treatment}{treatment factors.}
\item{reference}{reference treatment used for the comparison.}
\item{nsbp}{the number of patient subgroups.}
\item{subgroup}{subgroup factors.}
\item{scale}{the scale type for treatment effects (see above). }
\item{effect}{estimated treatment effects.}
\item{se}{standard error of treatment effects estimators.}
\item{LowerCI}{the lower limit of the confidence interval.}
\item{UpperCI}{the upper limit of the confidence interval.}
\item{test}{testing method used here, either "IBGA" or "LRT".}
\item{index}{the testing index used only for \code{test = "IBGA"}.}
\item{cvalue}{the critical value used only for \code{test = "LRT"}.}
\item{LowerTI}{the lower limit of the testing interval used when \code{test = "IBGA"}.}
\item{UpperTI}{the upper limit of the testing interval used when \code{test = "IBGA"}.}
\item{pvalue}{the pvalue for qualitative interactions.}
\item{power}{the power based on the observed data.}
\item{nobs}{the number of subjects.}
\item{missing}{the indexes of subjects with missing values.}
}
\description{
Test for qualitative interactions between treatment effects and patient subgroups
from the estimated treatment effect and its standard error directly.
Output all the results related with qualitative interaction tests as
a "qualint" object, just like the "qualint" function.
Two common tests for qualitative interactions are included: IBGA and LRT, among
which IBGA is the default.
Users need to input the estiamted treatment effect and its standard erro themselves,
therefore could accommodate any types of responses.
}
\details{
This function is a more generalized version of \code{qualint} in the sense that
it could be used for any types of responses. However, comepared to \code{qualint},
the user needs to input the estimated (for pvalue) or designed (for power )
treatment effects and its standard error by themselves to use this function. It
gives more freedom and allows users to choose the method they prefer before
testing for qualitative interactions.
}
\examples{
test9 <- qualval(effect = c(1.0, 0.5, -2.0), se = c(0.86, 0.64, 0.32))
print(test9)
plot(test9)
}
\author{
Lixi Yu, Eun-Young Suh, Guohua (James) Pan \cr
Maintainer: Lixi Yu \email{lixi-yu@uiowa.edu}
}
\references{
Gail and Simon (1985), Testing for qualitative interactions between
treatment effects and patient subsets, Biometrics, 41, 361-372.

Pan and Wolfe (1993), Tests for generalized problems of detecting
qualitative interaction, Technical Report No. 526, Department of Statistics,
The Ohio State University.

Pan and Wolfe (1997), Test for qualitative interaction of clinical
significance, Statistics in Medicine, 16, 1645-1652.
}
\seealso{
\code{\link{print.qualint}}, \code{\link{coef.qualint}},
\code{\link{plot.qualint}}, \code{\link{qualint}}
}

