% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_ticks.R
\name{to_ticks}
\alias{to_ticks}
\title{Convert candles to ticks}
\usage{
to_ticks(x)
}
\arguments{
\item{x}{candles, read 'Candles' in \link{Processor}}
}
\description{
Convert candles to ticks
}
\details{
Convert OHLCV candles to ticks using the following model. One candle is equivalent to four ticks \code{( time, price, volume )}: \code{( time - period, open, volume / 4 ); ( time - period / 2, high, volume / 4 ); ( time - period / 2, low, volume / 4 ); ( time - period / 100, close, volume / 4 )}. Assuming provided candles have frequent period ( less than a minute ) it is a good approximation for tick data which can be used to speed up back testing or if no raw tick data available.
}
\examples{
\donttest{

data( ticks )
candles = to_candles( ticks, timeframe = 60 )
to_ticks( candles )

}
}
