% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QLMDe.R
\name{QLMDe}
\alias{QLMDe}
\title{Quantile Least Mahalanobis Distance estimates}
\usage{
QLMDe(
  x,
  distname = c("GH", "norm", "sn"),
  K,
  data.name = deparse1(substitute(x)),
  constraint = character(),
  probs = QLMDp(x = x),
  init = c("logLik", "letterValue", "normix"),
  tol = .Machine$double.eps^0.25,
  maxiter = 1000,
  ...
)
}
\arguments{
\item{x}{\link[base]{numeric} \link[base]{vector}, the one-dimensional observations.}

\item{distname}{\link[base]{character} scalar, name of mixture distribution to be fitted.  Currently supports \code{'norm'} and \code{'GH'}.}

\item{K}{\link[base]{integer} scalar, number of components (e.g., must use \code{2L} instead of \code{2}).}

\item{data.name}{\link[base]{character} scalar, name for the observations for user-friendly print out.}

\item{constraint}{\link[base]{character} \link[base]{vector}, parameters (\eqn{g} and/or \eqn{h} for Tukey's \eqn{g}-&-\eqn{h} mixture) to be set at 0.
See \link{fmx_constraint} for details.}

\item{probs}{\link[base]{numeric} \link[base]{vector}, percentiles at where the sample and theoretical quantiles are to be matched.
See \link{QLMDp} for details.}

\item{init}{\link[base]{character} scalar for the method of initial values selection,
or an \linkS4class{fmx} object of the initial values.
See \link{fmx_hybrid} for more details.}

\item{tol, maxiter}{see \link{vuniroot2}}

\item{...}{additional parameters of \link[stats]{optim}}
}
\value{
\link{QLMDe} returns an \linkS4class{fmx} object.
}
\description{
The quantile least Mahalanobis distance algorithm estimates the parameters of
single-component or finite mixture distributions
by minimizing the Mahalanobis distance between the vectors of sample and theoretical quantiles.
See \link{QLMDp} for the default selection of probabilities at which the sample and theoretical quantiles are compared.

The default initial values are estimated based on trimmed \eqn{k}-means
clustering with re-assignment.
}
\details{
Quantile Least Mahalanobis Distance estimator fits a single-component or finite mixture distribution
by minimizing the Mahalanobis distance between
the theoretical and observed quantiles,
using the empirical quantile variance-covariance matrix \link{quantile_vcov}.
}
\examples{

hist(x1 <- CK5[[1L]])
\donttest{QLMDe(x1, distname = 'GH', K = 2L)}

}
\seealso{
\link[stats]{optim} \link{fmx_hybrid}
}
