# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' sort vector y by values in vector x
#' 
#' @param y numeric vector
#' @param x numeric vector
#' @keywords internal
#' @return numeric vector
Cpporder <- function(y, x) {
    .Call(`_R2sample_Cpporder`, y, x)
}

#' find test statistics for continuous data
#' 
#' @param x first continuous data set
#' @param y second continuous data set
#' @keywords internal
#' @return A vector of test statistics
TS_cont <- function(x, y) {
    .Call(`_R2sample_TS_cont`, x, y)
}

#' find test statistics for discrete data
#' 
#' @param x integer vector of data set 1
#' @param y integer vector of data set 2
#' @param vals numeric vector of values of discrete data set
#' @param ADweights A vector of weights for AD method
#' @keywords internal
#' @return A vector of test statistics
TS_disc <- function(x, y, vals, ADweights = as.numeric( c(2))) {
    .Call(`_R2sample_TS_disc`, x, y, vals, ADweights)
}

#' find test statistics for continuous data with weights
#' 
#' @param x first continuous data set
#' @param y second continuous data set
#' @param wx weights of x
#' @param wy weights of y
#' @keywords internal
#' @return A vector of test statistics
TSw_cont <- function(x, y, wx, wy) {
    .Call(`_R2sample_TSw_cont`, x, y, wx, wy)
}

#' Find test statistics for weighted discrete data
#' 
#' @param x integer vector of counts
#' @param y integer vector of counts
#' @param vals A numeric vector with the values of the discrete rv.
#' @param wx integer vector of weights
#' @param wy integer vector of weights
#' @keywords internal
#' @return A vector with test statistics
TSw_disc <- function(x, y, vals, wx, wy) {
    .Call(`_R2sample_TSw_disc`, x, y, vals, wx, wy)
}

#' find counts in bins. Useful for power calculations. Replaces hist command from R.
#' 
#' @param x numeric vector
#' @param bins numeric vector
#' @keywords internal
#' @return Integer vector of counts
bincounter <- function(x, bins) {
    .Call(`_R2sample_bincounter`, x, bins)
}

#' This function calculates the test statistics for continuous data
#' @param  dta data set
#' @param  TS routine
#' @param  typeTS format of TS
#' @param  TSextra list passed to TS function
#' @keywords internal
#' @return A vector of numbers
calcTS <- function(dta, TS, typeTS, TSextra) {
    .Call(`_R2sample_calcTS`, dta, TS, typeTS, TSextra)
}

#' simulate continuous data without weights
#' @param dta data set
#' @param TSextra extra stuff
#' @keywords internal
#' @return A list of permuted vectors
gen_sim_data <- function(dta, TSextra) {
    .Call(`_R2sample_gen_sim_data`, dta, TSextra)
}

#' simulate continuous data without weights
#' @param x first data set
#' @param y second data set
#' @param TSextra extra stuff
#' @keywords internal
#' @return A list of permuted vectors
gen_cont_noweights <- function(x, y, TSextra) {
    .Call(`_R2sample_gen_cont_noweights`, x, y, TSextra)
}

#' simulate continuous data with weights
#' @param x first data set
#' @param y second data set
#' @param wx weights of first data set
#' @param wy weights of second data set
#' @param TSextra extra stuff
#' @keywords internal
#' @return A list of permuted vectors
gen_cont_weights <- function(x, y, wx, wy, TSextra) {
    .Call(`_R2sample_gen_cont_weights`, x, y, wx, wy, TSextra)
}

#' simulate new discrete data
#' @param dtax first data set, counts
#' @param dtay second data set, counts
#' @param vals values of discrete random variable
#' @param TSextra extra stuff
#' @keywords internal
#' @return A list of permuted vectors
gen_disc <- function(dtax, dtay, vals, TSextra) {
    .Call(`_R2sample_gen_disc`, dtax, dtay, vals, TSextra)
}

#' a local function needed for the vignette
#' 
#' @param x An integer vector.
#' @param y An integer vector.
#' @param vals A numeric vector with the values of the discrete rv.
#' @return A vector with test statistics
#' @export
myTS2 <- function(x, y, vals) {
    .Call(`_R2sample_myTS2`, x, y, vals)
}

#' Find the power of various continuous tests via simutation or permutation.
#' 
#' @param rxy a function that generates x and y data.
#' @param TS routine to calculate test statistics for non-chi-square tests
#' @param xparam  arguments for r1.
#' @param yparam  arguments for r2.
#' @param typeTS indicator for type of test statistics
#' @param TSextra additional info passed to TS, if necessary
#' @param B =1000 number of simulation runs
#' @keywords internal
#' @return A list values of test statistics
powerC <- function(rxy, xparam, yparam, TS, typeTS, TSextra, B = 1000L) {
    .Call(`_R2sample_powerC`, rxy, xparam, yparam, TS, typeTS, TSextra, B)
}

#' cpp version of R routine rep
#' 
#' @param x numeric vector
#' @param times integer vector
#' @keywords internal
#' @return A numeric vector
repC <- function(x, times) {
    .Call(`_R2sample_repC`, x, times)
}

f <- function() {
    invisible(.Call(`_R2sample_f`))
}

test <- function(g) {
    invisible(.Call(`_R2sample_test`, g))
}

#' run test using either simulation or permutation.
#' 
#' @param dta a list with the data
#' @param TS routine to calculate test statistics for non-chi-square tests 
#' @param typeTS type of a test statistic
#' @param TSextra additional info passed to TS, if necessary
#' @param B =5000, number of simulation runs.
#' @keywords internal
#' @return A list with test statistics and p values
testC <- function(dta, TS, typeTS, TSextra, B = 5000L) {
    .Call(`_R2sample_testC`, dta, TS, typeTS, TSextra, B)
}

#' Find counts and/or sum of weights in bins. Useful for power calculations. Replaces hist command from R.
#' 
#' @param x numeric vector
#' @param bins numeric vector
#' @param w numeric vector of weights 
#' @keywords internal
#' @return sum of weights in bins
wbincounter <- function(x, bins, w) {
    .Call(`_R2sample_wbincounter`, x, bins, w)
}

#' find weights for several statistics for discrete data
#' 
#' @param dta A list with vectors x, y and vals.
#' @keywords internal
#' @return A vector of weights
weights <- function(dta) {
    .Call(`_R2sample_weights`, dta)
}

