% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base-Singleton.R
\name{Singleton}
\alias{Singleton}
\title{Singleton Pattern}
\description{
Ensure a class only has one instance, and provide a global point
of access to it.
}
\details{
\if{html}{\out{
<!-- One line about what the function does -->
}}


\emph{\strong{Singleton}} ensures a class only has one instance, and provide a
global point of access to it.
\subsection{How It Works}{
\enumerate{
\item Create only one instance of the \strong{Singleton} class; and
\item If an instance exists, then serve the same object again.
}

The main features of \strong{Singleton} are:
\itemize{
\item Ensuring that one and only one object of the class gets created;
\item Providing an access point for an object that is global to the
program; and
\item Controlling concurrent access to resources that are shared.
}
}

\subsection{When to Use It}{
\itemize{
\item In situations that require exactly one instance of a class, that
must be accessible to clients from a well-known access point. See
the \href{#example-1}{\code{Counter} example}.
}\if{html}{\out{
<div class="alert alert-danger">
}}


\strong{Caution:} Singletons can be a problem in multi-threaded applications,
especially when they manipulate mutable data.\if{html}{\out{
</div>
}}
\if{html}{\out{
<div class="alert alert-info">
}}


\strong{Tip:} Singletons work well for immutable data, such as reading from
some data source, since anything that can’t change isn’t going to run
into thread clash problems.\if{html}{\out{
</div>
}}

}
}
\examples{
# See more examples at <https://tidylab.github.io/R6P/articles>
address <- pryr::address

# In this example we implement a `Counter` that inherits the qualities of
# Singleton
Counter <- R6::R6Class("Counter", inherit = R6P::Singleton, public = list(
    count = 0,
    add_1 = function(){self$count = self$count + 1; invisible(self)}
))

# Whenever we call the constructor on `Counter`, we always get the exact same
# instance:
counter_A <- Counter$new()
counter_B <- Counter$new()

sprintf("counter_A was crated at \%s", address(counter_A))
sprintf("counter_B was crated at \%s", address(counter_B))

identical(counter_A, counter_B)

# The two objects are equal and located at the same address; thus, they are
# the same object.

# When we make a change in any of the class instances, the rest of the
# instances are changed as well.

# How many times has the counter been increased?
counter_A$count

# Increase the counter by 1
counter_A$add_1()

# How many times have the counters been increased?
counter_A$count
counter_B$count
}
\seealso{
Other base design patterns: 
\code{\link{NullObject}()},
\code{\link{ValueObject}()}
}
\concept{base design patterns}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Singleton$new()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create or retrieve an object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Singleton$new()}\if{html}{\out{</div>}}
}

}
}
