% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/representative.R
\name{representative_RAD}
\alias{representative_RAD}
\title{Computes representative normalized RAD of a group of normalized RADs.}
\usage{
representative_RAD(norm_rad, sample_ids = NULL, plot = F, min_rank = 1,
  confidence = 0.95, with_conf = TRUE, ...)
}
\arguments{
\item{norm_rad}{A matrix which contains the normalized RADs (samples in rows).}

\item{sample_ids}{Vector of row numbers of the desired group,
from which a representative RAD is going to be produced.}

\item{plot}{A logical. If \code{TRUE}, plots the repRAD. The plot would be added to the previous plot.}

\item{min_rank}{The minimum rank to be considered for making repRADs.}

\item{confidence}{Confidence interval of plotted repRAD. Default is 0.9.}

\item{with_conf}{A logical. If \code{TRUE}, plots the confidence interval in addition to repRAD. Only works when \code{plot} is \code{TRUE}.}

\item{...}{Other graphical parameters to use for plotting. This function uses internally the
functions \code{lines} and \code{polygon} to plot.}
}
\value{
A list of following parameters:

$average: Contains a vector of length equal to the columns of \code{norm_rad}. This in the representative normalized RAD which is
    the average of normalized RAD of the group.

$population_sd: A vector of length equal to the columns of \code{norm_rad} which contains the standard deviation
    for each rank.

$standard_error: A vector of length equal to the columns of \code{norm_rad} which contains the standard deviation
    of the mean for each rank. This vector is the result of \code{population_sd / sqrt(n)},
    when n is the number of members of the group (length of \code{sample_ids}).

If \code{plot = TRUE}, plot of the repRAD is produced and would be added to the previous plot.

If \code{with_conf = TRUE}, confidence interval would be added to the repRAD plot.
}
\description{
Computes representative normalized RAD of a group of normalized RADs.
}
\examples{
line_cols <- c("green","red","blue")
sample_classes <- c(1,1,1,1,2,2,3,3,1,1,2,3,3,1,1,2,3,3)
maxrank <- 400
data("gut_nrads")
nrads <- gut_nrads
nrads <- nrads$norm_matrix

#plot nrads
plot(1e10,xlim = c(1,maxrank),ylim = c(2e-5,1),log="xy",
     xlab = "rank",ylab = "abundance",cex.lab = 1.5,axes = FALSE)
sfsmisc::eaxis(side = 1,at = c(1,10,100,1000,10000))
sfsmisc::eaxis(side = 2,at = c(1e-4,1e-3,1e-2,1e-1,1),las = 0)
for(i in 1:nrow(nrads)){
    points(nrads[i,],type = 'l',col = line_cols[sample_classes[i]],lwd = 0.8)
}
#plot confidence intervals of representative nrads
a <- representative_RAD(norm_rad = nrads,sample_ids = which(sample_classes == 1),
                      plot = TRUE,confidence = 0.9,with_conf = TRUE,
                      col = scales::alpha(line_cols[1],0.5),border = NA)
a <- representative_RAD(norm_rad = nrads,sample_ids = which(sample_classes == 2),
                      plot = TRUE,confidence = 0.9,with_conf = TRUE,
                      col = scales::alpha(line_cols[2],0.5),border = NA)
a <- representative_RAD(norm_rad = nrads,sample_ids = which(sample_classes == 3),
                      plot = TRUE,confidence = 0.9,with_conf = TRUE,
                      col = scales::alpha(line_cols[3],0.5),border = NA)
#plot representative nrads
a <- representative_RAD(norm_rad = nrads,sample_ids = which(sample_classes == 1),
                      plot = TRUE,with_conf = FALSE,
                      col = scales::alpha(line_cols[1],0.8),lwd = 4)
a <- representative_RAD(norm_rad = nrads,sample_ids = which(sample_classes == 2),
                      plot = TRUE,with_conf = FALSE,
                      col = scales::alpha(line_cols[2],0.8),lwd = 4)
a <- representative_RAD(norm_rad = nrads,sample_ids = which(sample_classes == 3),
                      plot = TRUE,with_conf = FALSE,
                      col = scales::alpha(line_cols[3],0.8),lwd = 4)
legend("bottomleft",bty = "n",legend = c("pre Cp","under Cp","post Cp"),
col = line_cols,lwd = 3)

}
\seealso{
\code{\link{RADnormalization}} for normalize an abundance vector. This function return more details compared to \code{\link{RADnormalization_matrix}},
         \code{\link{RADnormalization_matrix}} for normalize an entire otutable,
         \code{\link{representative_point}} for study the representative of groups of samples in a multi-dimensional scaling plot,
}

