% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fooddb2msfinder.R
\name{fooddb2msfinder}
\alias{fooddb2msfinder}
\title{foodb2msfinder}
\usage{
fooddb2msfinder(foodb.files = NULL, out.dir = NULL,
  out.name = "FoodDB_for_MSFinder.txt")
}
\arguments{
\item{foodb.files}{default = NULL, if path is set, will read automatically.  If NULL, direcory selection by user.}

\item{out.dir}{default = NULL.  Can set to exiseting directory with full path name.  If NULL, direcory selection by user.}

\item{out.name}{default = "FoodDB_for_MSFinder.txt".}
}
\value{
Nothing is returned - output file written to directory set by 'out.dir' and name set by 'out.name'
}
\description{
convenience function for converting FoodDB database export format to MSFinder custom database import format. Before running this, please have downloaded .csv files from FoodDB with the appropriate Display Field Headers (see details)
}
\details{
Input file(s) should be csv formatted, with required headers of 'Name',	'Smiles',	'Inchikey',	'Chemical formula', and 'Mono mass' - case sensitive.  Ouput will be in tab delimited text format in directory of choice.
}
\references{
Broeckling CD, Afsar FA, Neumann S, Ben-Hur A, Prenni JE. RAMClust: a novel feature clustering method enables spectral-matching-based annotation for metabolomics data. Anal Chem. 2014 Jul 15;86(14):6812-7. doi: 10.1021/ac501530d.  Epub 2014 Jun 26. PubMed PMID: 24927477.
}
\author{
Corey Broeckling
}
\concept{MSFinder}
\concept{RAMClustR}
\concept{feature}
\concept{mass spectrometry}
\concept{metabolomics}
\concept{ramclustR}
\concept{xcms}
