% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_main_GAUSSIAN.R
\name{simulation_main_GAUSSIAN}
\alias{simulation_main_GAUSSIAN}
\title{Doubly Adaptive Biased Coin Design with Simulated Data (Gaussian Responses)}
\usage{
simulation_main_GAUSSIAN(n, nstart, mu, sd, nstop, replication, group_allo,
 rho_func_index, rho_func, alpha, sig_level)
}
\arguments{
\item{n}{The number of patients. The default is 500.}

\item{nstart}{Burn-in sample size of each arm. The default is n/20.}

\item{mu}{A vector of mean response for each treatment arm
(where the first element refers to the control arm).
The length of mu should correspond to the number of arms.
The default is mu = c(4.5,5).}

\item{sd}{A vector of response standard deviations for each treatment arm.
(where the first element refers to the control arm).
The length of sd should correspond to the number of arms.
The default is sd = c(1.32, 0.72).}

\item{nstop}{A vector of stopping cap of sample size for each arm. The trial
stops if at least one arm reaches the corresponding cap.
The default is NULL, which means no cap.}

\item{replication}{the number of replications of the simulation. The default
is 100.}

\item{group_allo}{A number or a vector of group size(s) for allocation.
If a number is given, the allocation ratios will be updated for each batch of
 group_allo samples. If a vector is given, the allocation ratios will be
 updated sequentially in group according to the vector.
 Any value greater than n will be omitted.
The default is group_allo=1, which is the same as group_allo = seq(nstart*length(p)+1,n).}

\item{rho_func_index}{Supply a number of 1 or 2 indicting the
allocation function to use.
1 = Zhang-Rosenberger allocation (2-arm allocation only);
2 (default) = Neyman allocation.}

\item{rho_func}{Supply a user-specified allocation function of Mean_RK and
SD_RK when rho_func_index is NULL. Default is NULL.}

\item{alpha}{Supply a number indicating the subscripts of the probability
function. The default is 2.}

\item{sig_level}{Significant level. The default is 0.05.}
}
\value{
\itemize{
  \item allocation_mean - Average of allocation in each arm based on `replication` repeats.
  \item allocation_sd - Standard deviation of allocation in each arm based on `replication` repeats.
  \item SS_mean - Average of sample size in each arm based on `replication` repeats.
  \item SS_sd - Standard deviation of sample size in each arm based on `replication` repeats.
  \item power_aov - Average power of ANOVA test.
  \item power_oneside - Average power for each of the k-th arm to perform one-sided Welch T-test against H0: mu_1>mu_k without multiplicity adjustment.
  \item mu_estimate_mean - Average of estimated response mean `mu`.
  \item sd_estimate_mean - Average of estimated response standard deviation `sd`.
  \item mu_estimate_sd - Standard deviation of estimated response mean `mu`.
  \item sd_estimate_sd - Standard deviation of estimated response standard deviation `sd`.
}
}
\description{
Allocates patients to one of treatments based on the doubly adaptive biased
coin design with simulated data.
}
\details{
'simulation_main_GAUSSIAN' can sample response and adaptively
randomize subjects group by group.
}
\examples{

## Default method
simulation_main_GAUSSIAN(
n = 500,
nstart = round(500 / 20),
mu = c(4.5,5),
sd = c(1.32,0.72),
nstop=c(500,500),
replication = 5,
group_allo = 1,
rho_func_index = 2,
rho_func = NULL,
alpha = 2,
sig_level = 0.05
)

}
