% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Connection.R
\docType{methods}
\name{dbExistsTable}
\alias{dbExistsTable}
\alias{dbExistsTable,AthenaConnection,character-method}
\title{Does Athena table exist?}
\usage{
\S4method{dbExistsTable}{AthenaConnection,character}(conn, name, ...)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[=dbConnect]{dbConnect()}}.}

\item{name}{A character string specifying a DBMS table name.}

\item{...}{Other parameters passed on to methods.}
}
\value{
\code{dbExistsTable()} returns logical scalar. \code{TRUE} if the table exists, \code{FALSE} otherwise.
}
\description{
Returns logical scalar if the table exists or not. \code{TRUE} if the table exists, \code{FALSE} otherwise.
}
\examples{
\dontrun{
# Note: 
# - Require AWS Account to run below example.
# - Different connection methods can be used please see `RAthena::dbConnect` documnentation

library(DBI)

# Demo connection to Athena using profile name 
con <- dbConnect(RAthena::athena())

# Write data.frame to Athena table
dbWriteTable(con, "mtcars", mtcars,
             partition=c("TIMESTAMP" = format(Sys.Date(), "\%Y\%m\%d")),
             s3.location = "s3://mybucket/data/")
             
# Check if table exists from Athena
dbExistsTable(con, "mtcars")

# Disconnect conenction
dbDisconnect(con)
}
}
\seealso{
\code{\link[DBI]{dbExistsTable}}
}
