% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RBF-fn.R
\name{backf.cl}
\alias{backf.cl}
\title{Classic Backfitting}
\usage{
backf.cl(Xp, yp, point = NULL, windows, epsilon = 1e-06, degree = 0,
  prob = NULL, max.it = 100)
}
\arguments{
\item{Xp}{a matrix (n x p) containing the explanatory variables}

\item{yp}{vector of responses (missing values are allowed)}

\item{point}{matrix of points where predictions will be computed and returned.}

\item{windows}{vector of bandwidths for the local polynomial smoother,
one per explanatory variable.}

\item{epsilon}{convergence criterion. Maximum allowed relative difference between
consecutive estimates}

\item{degree}{degree of the local polynomial smoother. Defaults to \code{0} (local constant).}

\item{prob}{vector of probabilities of observing each response (length n).
Defaults to \code{NULL} and in that case it is ignored.}

\item{max.it}{Maximum number of iterations for the algorithm.}
}
\value{
A list with the following components:
\item{alpha}{Estimate for the intercept.}
\item{g.matrix }{Matrix of estimated additive components (n by p).}
\item{prediction }{Matrix of estimated additive components for the points listed in
the argument \code{point}.}
}
\description{
This function computes the standard backfitting algorithm for additive models.
}
\details{
This function computes the standard backfitting algorithm for additive models,
using a squared loss function and local polynomial smoothers.
}
\examples{
data(airquality)
x <- airquality
x <- x[complete.cases(x), c('Ozone', 'Solar.R', 'Wind', 'Temp')]
y <- as.vector(x$Ozone)
x <- as.matrix(x[, c('Solar.R', 'Wind', 'Temp')])
tmp <- backf.cl(Xp = x, yp=y, windows=c(130, 9, 10), degree=1)

}
\references{
Hasie, TJ and Tibshirani, RJ. Generalized Additive Models, 1990. Chapman
and Hall, London.
}
\author{
Matias Salibian-Barrera, \email{matias@stat.ubc.ca}, Alejandra Martinez
}
