% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regu-est.R
\name{ate.aipw}
\alias{ate.aipw}
\title{Augmented inverse probability weighted estimation of population means}
\usage{
ate.aipw(y, tr, mfp, mfo, off = NULL)
}
\arguments{
\item{y}{An \eqn{n} x \eqn{1} vector of observed outcomes.}

\item{tr}{An \eqn{n} x \eqn{1} vector of treatment indicators (=1 if treated or 0 if untreated).}

\item{mfp}{An \eqn{n} x \eqn{2} matrix of fitted propensity scores for untreated (first column) and treated (second column).}

\item{mfo}{An \eqn{n} x \eqn{2} matrix of fitted values from outcome regression, for untreated (first column) and treated (second column).}

\item{off}{A \eqn{2} x \eqn{1} vector of offset values (e.g., the true values in simulations) used to calculate the z-statistics.}
}
\value{
\item{one}{A \eqn{2} x \eqn{1} vector of direct IPW estimates of 1.}
\item{ipw}{A \eqn{2} x \eqn{1} vector of ratio IPW estimates of means.}
\item{or}{A \eqn{2} x \eqn{1} vector of outcome regression estimates of means.}
\item{est}{A \eqn{2} x \eqn{1} vector of augmented IPW estimates of means.}
\item{var}{The estimated variances associated with the augmented IPW estimates of means.}
\item{ze}{The z-statistics for the augmented IPW estimates of means, compared to \code{off}.}
\item{diff}{The augmented IPW estimate of ATE.}
\item{diff.var}{The estimated variance associated with the augmented IPW estimate of ATE.}
\item{diff.ze}{The z-statistic for the augmented IPW estimate of ATE.}
}
\description{
This function implements augmented inverse probability weighted (IPW) estimation of average treatment effects (ATEs),
provided both fitted propensity scores and fitted values from outcome regression.
}
\references{
Tan, Z. (2017) Regularized calibrated estimation of propensity scores with model misspecification and high-dimensional data, arXiv:1710.08074. 

Tan, Z. (2019) Model-assisted inference for treatment effects using regularized calibrated estimation with high-dimensional data, 
\emph{Annals of Statistics}, to appear (preprint arXiv:1801.09817).
}
