% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcbr.fit.KW1.R
\name{rcbr.fit.KW1}
\alias{rcbr.fit.KW1}
\title{NPMLE fitting for the Cosslett random coefficient binary response model}
\usage{
rcbr.fit.KW1(X, y, control)
}
\arguments{
\item{X}{the design matrix expected to have an intercept column of
ones as the first column, the last column is presumed to contain values of
the covariate that is designated to have coefficient one.}

\item{y}{the binary response.}

\item{control}{is a list of parameters for the fitting, see
\code{KW.control} for further details.}
}
\value{
a list with components:
\itemize{
  \item  x evaluation points for the fitted distribution
  \item  y estimated mass associated with the \code{v} points
  \item  logLik the loglikelihood value of the fit
  \item  status mosek solution status
}
}
\description{
This is the original one dimensional version of the Cosslett model, also
known as the current status model:
\deqn{P(y = 1 | v) = \int I (\eta > v)dF(\eta).}
invoked with the formula \code{y ~ v}.  By default the algorithm computes a vector
of potential locations for the mass points of \eqn{\hat F} by finding interior
points of the intervals between the ordered \code{v}, and then solving a convex
optimization problem to determine these masses.  Alternatively, a vector of
predetermined locations can be passed via the control argument.  Additional
covariate effects can be accommodated by either specifying a fixed offset in
the call to \code{rcbr} or by using the profile likelihood function \code{prcbr}.
}
\references{
Gu, J. and R. Koenker (2018)  Nonparametric maximum likelihood estimation 
of the random coefficients binary choice model, preprint.
}
\author{
Jiaying Gu and Roger Koenker
}
\keyword{nonparametrics}
