% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.functions.r
\name{tablesomersDC}
\alias{tablesomersDC}
\title{Calculates the Somers' d measure of association for a cross-tabulation.}
\usage{
tablesomersDC(tab, dep = 1, digits = 3)
}
\arguments{
\item{tab}{The conditional frequencies of a cross-tabulation. The dependent and independent variable in cross-tabulation should be be ordinal-level (ordered factors).}

\item{dep}{which dimension stands for the dependent variable (1 = ROWS, 2 = COLS), default is 2.}

\item{digits}{Number of decimal places reported in result (defaults to 3).}
}
\value{
Returns the value of Somers' D.
}
\description{
Given a table of conditional frequencies, tablesomersDC calculates and returns Somers' D, a measure of association between two ordinal-level variables.
}
\examples{
  library(RCPA3)
  
  conditional.frequencies <- table(dv=states$lgbtq.equality.3cat, iv=states$religiosity3)
  tablesomersDC(tab=conditional.frequencies)
}
\keyword{internal}
