% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treatment_assign.R
\name{treatment_assign}
\alias{treatment_assign}
\title{treatmen_assign() carries out robust treatment assignment by strata/blocks}
\usage{
treatment_assign(
  data,
  share_control,
  n_t = 2,
  strata_varlist,
  missfits = c("global", "NA", "strata"),
  seed = 1990,
  share_ti = rep(1/n_t - share_control/n_t, times = n_t),
  key
)
}
\arguments{
\item{data}{A data.frame, tibble or data.table}

\item{share_control}{share of the observations assigned to control group}

\item{n_t}{Number of treatments groups}

\item{strata_varlist}{vector of categorical variables to form the strata/blocks for random assignment. 
Should be in the form of vars(var1, var2, ...)}

\item{missfits}{How to handle the misfits. Default is "global". See Carril (2016) for details.}

\item{seed}{A number used to set.seed().}

\item{share_ti}{The share of each treatment group. If NULL (Default), each treatment group will 
have equal share.}

\item{key}{The key identifier column of data.}
}
\value{
A list: "data" = the data with key, treat, strata, misfit column., 
"summary_strata" = A summary tibble with the membership of each strata and its size.
}
\description{
treatmen_assign() carries out robust treatment assignment by strata/blocks
}
\details{
This function creates a variable that indicates the treatment status. The random 
assignment is made by strata/blocks. It can handle equal or unequal treatment shares. 
Finally, it has three methods available to handle misfits (same as randtreat in STATA):
"global": assigning the observations that couldn't be randomly assigned globally, 
"strata": assigning the observations that couldn't be randomly assigned by strata,
"NA": set the the treat observations that couldn't be randomly assigned to NA.
}
\examples{
data<-data.frame(key = c(1:1000), 
                 ing_quartile = rep(c("Q1", "Q2", "Q3", "Q4"), each = 250), 
                 age_quartile = rep(c("Q1", "Q2", "Q3", "Q4"), times = 250))
assigment<-treatment_assign(data = data, share_control = 0.1, n_t = 3,
                            strata_varlist = dplyr::vars(ing_quartile, 
                            age_quartile), missfits = "strata", 
                            seed = 1990, key = "key")
table(data$treat, useNA = "ifany")
prop.table(table(data$treat, useNA = "ifany"))
}
