   divlist<-c("BrBG","PiYG","PRGn","PuOr","RdBu","RdGy","RdYlBu","RdYlGn","Spectral")
   quallist<-c("Accent","Dark2","Paired","Pastel1","Pastel2","Set1","Set2","Set3")
   seqlist<-c("Blues","BuGn","BuPu","GnBu","Greens","Greys","Oranges","OrRd",
   	"PuBu","PuBuGn","PuRd","Purples","RdPu","Reds","YlGn","YlGnBu","YlOrBr","YlOrRd")

   divnum <- rep(11, length(divlist))
   qualnum <- c( 8, 8, 12, 9, 8, 9, 8, 12)
   seqnum <- rep(9, length(seqlist))

   namelist<-c(divlist,quallist,seqlist)
   maxcolors <- c(divnum,qualnum,seqnum)
   catlist<-rep(c("div","qual","seq"),c(length(divlist),length(quallist),length(seqlist)))

   brewer.pal.info<-data.frame(maxcolors=maxcolors,category=catlist,row.names=namelist)



brewer.pal<-function(n,name){
   if(!(name %in% namelist)){
   stop(paste(name,"is not a valid palette name for brewer.pal\n"))
   }   
   if(n<3){ 
   warning("minimal value for n is 3, returning requested palette with 3 different levels\n")
   return(brewer.pal(3,name))
   }
   if(n>maxcolors[which(name==namelist)]){
   warning(paste("n too large, allowed maximum for palette",name,"is",maxcolors[which(name==namelist)]),
        "\nReturning the palette you asked for with that many colors\n")
   return(brewer.pal(maxcolors[which(name==namelist)],name))
   }
   
   switch(name,        
    Accent = switch(n-2,            
        rgb(c(127,190,253),
            c(201,174,192),
            c(127,212,134),maxColorValue=255),
        rgb(c(127,190,253,255),
            c(201,174,192,255),
            c(127,212,134,153),maxColorValue=255),
        rgb(c(127,190,253,255,56),
            c(201,174,192,255,108),
            c(127,212,134,153,176),maxColorValue=255),
        rgb(c(127,190,253,255,56,240),
            c(201,174,192,255,108,2),
            c(127,212,134,153,176,127),maxColorValue=255),
        rgb(c(127,190,253,255,56,240,191),
            c(201,174,192,255,108,2,91),
            c(127,212,134,153,176,127,23),maxColorValue=255),
        rgb(c(127,190,253,255,56,240,191,102),
            c(201,174,192,255,108,2,91,102),
            c(127,212,134,153,176,127,23,102),maxColorValue=255)
        ),          
    Blues = switch(n-2,            
        rgb(c(222,158,49),
            c(235,202,130),
            c(247,225,189),maxColorValue=255),
        rgb(c(239,189,107,33),
            c(243,215,174,113),
            c(255,231,214,181),maxColorValue=255),
        rgb(c(239,189,107,49,8),
            c(243,215,174,130,81),
            c(255,231,214,189,156),maxColorValue=255),
        rgb(c(239,198,158,107,49,8),
            c(243,219,202,174,130,81),
            c(255,239,225,214,189,156),maxColorValue=255),
        rgb(c(239,198,158,107,66,33,8),
            c(243,219,202,174,146,113,69),
            c(255,239,225,214,198,181,148),maxColorValue=255),
        rgb(c(247,222,198,158,107,66,33,8),
            c(251,235,219,202,174,146,113,69),
            c(255,247,239,225,214,198,181,148),maxColorValue=255),
        rgb(c(247,222,198,158,107,66,33,8,8),
            c(251,235,219,202,174,146,113,81,48),
            c(255,247,239,225,214,198,181,156,107),maxColorValue=255)
        ),          
    BrBG = switch(n-2,            
        rgb(c(216,245,90),
            c(179,245,180),
            c(101,245,172),maxColorValue=255),
        rgb(c(166,223,128,1),
            c(97,194,205,133),
            c(26,125,193,113),maxColorValue=255),
        rgb(c(166,223,245,128,1),
            c(97,194,245,205,133),
            c(26,125,245,193,113),maxColorValue=255),
        rgb(c(140,216,246,199,90,1),
            c(81,179,232,234,180,102),
            c(10,101,195,229,172,94),maxColorValue=255),
        rgb(c(140,216,246,245,199,90,1),
            c(81,179,232,245,234,180,102),
            c(10,101,195,245,229,172,94),maxColorValue=255),
        rgb(c(140,191,223,246,199,128,53,1),
            c(81,129,194,232,234,205,151,102),
            c(10,45,125,195,229,193,143,94),maxColorValue=255),
        rgb(c(140,191,223,246,245,199,128,53,1),
            c(81,129,194,232,245,234,205,151,102),
            c(10,45,125,195,245,229,193,143,94),maxColorValue=255),
        rgb(c(84,140,191,223,246,199,128,53,1,0),
            c(48,81,129,194,232,234,205,151,102,60),
            c(5,10,45,125,195,229,193,143,94,48),maxColorValue=255),
        rgb(c(84,140,191,223,246,245,199,128,53,1,0),
            c(48,81,129,194,232,245,234,205,151,102,60),
            c(5,10,45,125,195,245,229,193,143,94,48),maxColorValue=255)
        ),         
    BuGn =  switch(n-2,            
        rgb(c(229,153,44),
            c(245,216,162),
            c(249,201,95),maxColorValue=255),
        rgb(c(237,178,102,35),
            c(248,226,194,139),
            c(251,226,164,69),maxColorValue=255),
        rgb(c(237,178,102,44,0),
            c(248,226,194,162,109),
            c(251,226,164,95,44),maxColorValue=255),
        rgb(c(237,204,153,102,44,0),
            c(248,236,216,194,162,109),
            c(251,230,201,164,95,44),maxColorValue=255),
        rgb(c(237,204,153,102,65,35,0),
            c(248,236,216,194,174,139,88),
            c(251,230,201,164,118,69,36),maxColorValue=255),
        rgb(c(247,229,204,153,102,65,35,0),
            c(252,245,236,216,194,174,139,88),
            c(253,249,230,201,164,118,69,36),maxColorValue=255),
        rgb(c(247,229,204,153,102,65,35,0,0),
            c(252,245,236,216,194,174,139,109,68),
            c(253,249,230,201,164,118,69,44,27),maxColorValue=255)
        ),         
    BuPu =  switch(n-2,
        rgb(c(224,158,136),
            c(236,188,86),
            c(244,218,167),maxColorValue=255),
        rgb(c(237,179,140,136),
            c(248,205,150,65),
            c(251,227,198,157),maxColorValue=255),
        rgb(c(237,179,140,136,129),
            c(248,205,150,86,15),
            c(251,227,198,167,124),maxColorValue=255),
        rgb(c(237,191,158,140,136,129),
            c(248,211,188,150,86,15),
            c(251,230,218,198,167,124),maxColorValue=255),
        rgb(c(237,191,158,140,140,136,110),
            c(248,211,188,150,107,65,1),
            c(251,230,218,198,177,157,107),maxColorValue=255),
        rgb(c(247,224,191,158,140,140,136,110),
            c(252,236,211,188,150,107,65,1),
            c(253,244,230,218,198,177,157,107),maxColorValue=255),
        rgb(c(247,224,191,158,140,140,136,129,77),
            c(252,236,211,188,150,107,65,15,0),
            c(253,244,230,218,198,177,157,124,75),maxColorValue=255)
        ),          
    Dark2 =  switch(n-2,            
        rgb(c(27,217,117),
            c(158,95,112),
            c(119,2,179),maxColorValue=255),
        rgb(c(27,217,117,231),
            c(158,95,112,41),
            c(119,2,179,138),maxColorValue=255),
        rgb(c(27,217,117,231,102),
            c(158,95,112,41,166),
            c(119,2,179,138,30),maxColorValue=255),
        rgb(c(27,217,117,231,102,230),
            c(158,95,112,41,166,171),
            c(119,2,179,138,30,2),maxColorValue=255),
        rgb(c(27,217,117,231,102,230,166),
            c(158,95,112,41,166,171,118),
            c(119,2,179,138,30,2,29),maxColorValue=255),
        rgb(c(27,217,117,231,102,230,166,102),
            c(158,95,112,41,166,171,118,102),
            c(119,2,179,138,30,2,29,102),maxColorValue=255)
        ),
    GnBu =  switch(n-2,
        rgb(c(224,168,67),
            c(243,221,162),
            c(219,181,202),maxColorValue=255),
        rgb(c(240,186,123,43),
            c(249,228,204,140),
            c(232,188,196,190),maxColorValue=255),
        rgb(c(240,186,123,67,8),
            c(249,228,204,162,104),
            c(232,188,196,202,172),maxColorValue=255),
        rgb(c(240,204,168,123,67,8),
            c(249,235,221,204,162,104),
            c(232,197,181,196,202,172),maxColorValue=255),
        rgb(c(240,204,168,123,78,43,8),
            c(249,235,221,204,179,140,88),
            c(232,197,181,196,211,190,158),maxColorValue=255),
        rgb(c(247,224,204,168,123,78,43,8),
            c(252,243,235,221,204,179,140,88),
            c(240,219,197,181,196,211,190,158),maxColorValue=255),
        rgb(c(247,224,204,168,123,78,43,8,8),
            c(252,243,235,221,204,179,140,104,64),
            c(240,219,197,181,196,211,190,172,129),maxColorValue=255)
        ),          
    Greens = switch(n-2,            
    rgb(c(229,161,49),c(245,217,163),c(224,155,84),maxColorValue=255),
        rgb(c(237,186,116,35),
            c(248,228,196,139),
            c(233,179,118,69),maxColorValue=255),
        rgb(c(237,186,116,49,0),
            c(248,228,196,163,109),
            c(233,179,118,84,44),maxColorValue=255),
        rgb(c(237,199,161,116,49,0),
            c(248,233,217,196,163,109),
            c(233,192,155,118,84,44),maxColorValue=255),
        rgb(c(237,199,161,116,65,35,0),
            c(248,233,217,196,171,139,90),
            c(233,192,155,118,93,69,50),maxColorValue=255),
        rgb(c(247,229,199,161,116,65,35,0),
            c(252,245,233,217,196,171,139,90),
            c(245,224,192,155,118,93,69,50),maxColorValue=255),
        rgb(c(247,229,199,161,116,65,35,0,0),
            c(252,245,233,217,196,171,139,109,68),
            c(245,224,192,155,118,93,69,44,27),maxColorValue=255)
        ),          
    Greys =  switch(n-2,            
        rgb(c(240,189,99),
            c(240,189,99),
            c(240,189,99),maxColorValue=255),
        rgb(c(247,204,150,82),
            c(247,204,150,82),
            c(247,204,150,82),maxColorValue=255),
        rgb(c(247,204,150,99,37),
            c(247,204,150,99,37),
            c(247,204,150,99,37),maxColorValue=255),
        rgb(c(247,217,189,150,99,37),
            c(247,217,189,150,99,37),
            c(247,217,189,150,99,37),maxColorValue=255),
        rgb(c(247,217,189,150,115,82,37),
            c(247,217,189,150,115,82,37),
            c(247,217,189,150,115,82,37),maxColorValue=255),
        rgb(c(255,240,217,189,150,115,82,37),
            c(255,240,217,189,150,115,82,37),
            c(255,240,217,189,150,115,82,37),maxColorValue=255),
        rgb(c(255,240,217,189,150,115,82,37,0),
            c(255,240,217,189,150,115,82,37,0),
            c(255,240,217,189,150,115,82,37,0),maxColorValue=255)
        ),          
    Oranges =   switch(n-2,            
        rgb(c(254,253,230),
            c(230,174,85),
            c(206,107,13),maxColorValue=255),
        rgb(c(254,253,253,217),
            c(237,190,141,71),
            c(222,133,60,1),maxColorValue=255),
        rgb(c(254,253,253,230,166),
            c(237,190,141,85,54),
            c(222,133,60,13,3),maxColorValue=255),
        rgb(c(254,253,253,253,230,166),
            c(237,208,174,141,85,54),
            c(222,162,107,60,13,3),maxColorValue=255),
        rgb(c(254,253,253,253,241,217,140),
            c(237,208,174,141,105,72,45),
            c(222,162,107,60,19,1,4),maxColorValue=255),
        rgb(c(255,254,253,253,253,241,217,140),
            c(245,230,208,174,141,105,72,45),
            c(235,206,162,107,60,19,1,4),maxColorValue=255),
        rgb(c(255,254,253,253,253,241,217,166,127),
            c(245,230,208,174,141,105,72,54,39),
            c(235,206,162,107,60,19,1,3,4),maxColorValue=255)
        ),          
    OrRd =  switch(n-2,            
        rgb(c(254,253,227),
            c(232,187,74),
            c(200,132,51),maxColorValue=255),
        rgb(c(254,253,252,215),
            c(240,204,141,48),
            c(217,138,89,31),maxColorValue=255),
        rgb(c(254,253,252,227,179),
            c(240,204,141,74,0),
            c(217,138,89,51,0),maxColorValue=255),
        rgb(c(254,253,253,252,227,179),
            c(240,212,187,141,74,0),
            c(217,158,132,89,51,0),maxColorValue=255),
        rgb(c(254,253,253,252,239,215,153),
            c(240,212,187,141,101,48,0),
            c(217,158,132,89,72,31,0),maxColorValue=255),
        rgb(c(255,254,253,253,252,239,215,153),
            c(247,232,212,187,141,101,48,0),
            c(236,200,158,132,89,72,31,0),maxColorValue=255),
        rgb(c(255,254,253,253,252,239,215,179,127),
            c(247,232,212,187,141,101,48,0,0),
            c(236,200,158,132,89,72,31,0,0),maxColorValue=255)
        ),          
    Paired = switch(n-2,            
        rgb(c(166,31,178),
            c(206,120,223),
            c(227,180,138),maxColorValue=255),
        rgb(c(166,31,178,51),
            c(206,120,223,160),
            c(227,180,138,44),maxColorValue=255),
        rgb(c(166,31,178,51,251),
            c(206,120,223,160,154),
            c(227,180,138,44,153),maxColorValue=255),
        rgb(c(166,31,178,51,251,227),
            c(206,120,223,160,154,26),
            c(227,180,138,44,153,28),maxColorValue=255),
        rgb(c(166,31,178,51,251,227,253),
            c(206,120,223,160,154,26,191),
            c(227,180,138,44,153,28,111),maxColorValue=255),
        rgb(c(166,31,178,51,251,227,253,255),
            c(206,120,223,160,154,26,191,127),
            c(227,180,138,44,153,28,111,0),maxColorValue=255),
        rgb(c(166,31,178,51,251,227,253,255,202),
            c(206,120,223,160,154,26,191,127,178),
            c(227,180,138,44,153,28,111,0,214),maxColorValue=255),
        rgb(c(166,31,178,51,251,227,253,255,202,106),
            c(206,120,223,160,154,26,191,127,178,61),
            c(227,180,138,44,153,28,111,0,214,154),maxColorValue=255),
        rgb(c(166,31,178,51,251,227,253,255,202,106,255),
            c(206,120,223,160,154,26,191,127,178,61,255),
            c(227,180,138,44,153,28,111,0,214,154,153),maxColorValue=255),
        rgb(c(166,31,178,51,251,227,253,255,202,106,255,),
            c(206,120,223,160,154,26,191,127,178,61,255,),
            c(227,180,138,44,153,28,111,0,214,154,153,),maxColorValue=255)
        ),          
    Pastel1 =   switch(n-2,
        rgb(c(251,179,204),
            c(180,205,235),
            c(174,227,197),maxColorValue=255),
        rgb(c(251,179,204,222),
            c(180,205,235,203),
            c(174,227,197,228),maxColorValue=255),
        rgb(c(251,179,204,222,254),
            c(180,205,235,203,217),
            c(174,227,197,228,166),maxColorValue=255),
        rgb(c(251,179,204,222,254,255),
            c(180,205,235,203,217,255),
            c(174,227,197,228,166,204),maxColorValue=255),
        rgb(c(251,179,204,222,254,255,229),
            c(180,205,235,203,217,255,216),
            c(174,227,197,228,166,204,189),maxColorValue=255),
        rgb(c(251,179,204,222,254,255,229,253),
            c(180,205,235,203,217,255,216,218),
            c(174,227,197,228,166,204,189,236),maxColorValue=255),
        rgb(c(251,179,204,222,254,255,229,253,242),
            c(180,205,235,203,217,255,216,218,242),
            c(174,227,197,228,166,204,189,236,242),maxColorValue=255)
        ),          
    Pastel2 =   switch(n-2,            
        rgb(c(179,253,203),
            c(226,205,213),
            c(205,172,232),maxColorValue=255),
        rgb(c(179,253,203,244),
            c(226,205,213,202),
            c(205,172,232,228),maxColorValue=255),
        rgb(c(179,253,203,244,230),
            c(226,205,213,202,245),
            c(205,172,232,228,201),maxColorValue=255),
        rgb(c(179,253,203,244,230,255),
            c(226,205,213,202,245,242),
            c(205,172,232,228,201,174),maxColorValue=255),
        rgb(c(179,253,203,244,230,255,241),
            c(226,205,213,202,245,242,226),
            c(205,172,232,228,201,174,204),maxColorValue=255),
        rgb(c(179,253,203,244,230,255,241,204),
            c(226,205,213,202,245,242,226,204),
            c(205,172,232,228,201,174,204,204),maxColorValue=255)
        ),          
    PiYG =  switch(n-2,            
        rgb(c(233,247,161),
            c(163,247,215),
            c(201,247,106),maxColorValue=255),
        rgb(c(208,241,184,77),
            c(28,182,225,172),
            c(139,218,134,38),maxColorValue=255),
        rgb(c(208,241,247,184,77),
            c(28,182,247,225,172),
            c(139,218,247,134,38),maxColorValue=255),
        rgb(c(197,233,253,230,161,77),
            c(27,163,224,245,215,146),
            c(125,201,239,208,106,33),maxColorValue=255),
        rgb(c(197,233,253,247,230,161,77),
            c(27,163,224,247,245,215,146),
            c(125,201,239,247,208,106,33),maxColorValue=255),
        rgb(c(197,222,241,253,230,184,127,77),
            c(27,119,182,224,245,225,188,146),
            c(125,174,218,239,208,134,65,33),maxColorValue=255),
        rgb(c(197,222,241,253,247,230,184,127,77),
            c(27,119,182,224,247,245,225,188,146),
            c(125,174,218,239,247,208,134,65,33),maxColorValue=255),
        rgb(c(142,197,222,241,253,230,184,127,77,39),
            c(1,27,119,182,224,245,225,188,146,100),
            c(82,125,174,218,239,208,134,65,33,25),maxColorValue=255),
        rgb(c(142,197,222,241,253,247,230,184,127,77,39),
            c(1,27,119,182,224,247,245,225,188,146,100),
            c(82,125,174,218,239,247,208,134,65,33,25),maxColorValue=255)
        ),          
    PRGn =  switch(n-2,            
        rgb(c(175,247,127),
            c(141,247,191),
            c(195,247,123),maxColorValue=255),
        rgb(c(123,194,166,0),
            c(50,165,219,136),
            c(148,207,160,55),maxColorValue=255),
        rgb(c(123,194,247,166,0),
            c(50,165,247,219,136),
            c(148,207,247,160,55),maxColorValue=255),
        rgb(c(118,175,231,217,127,27),
            c(42,141,212,240,191,120),
            c(131,195,232,211,123,55),maxColorValue=255),
        rgb(c(118,175,231,247,217,127,27),
            c(42,141,212,247,240,191,120),
            c(131,195,232,247,211,123,55),maxColorValue=255),
        rgb(c(118,153,194,231,217,166,90,27),
            c(42,112,165,212,240,219,174,120),
            c(131,171,207,232,211,160,97,55),maxColorValue=255),
        rgb(c(118,153,194,231,247,217,166,90,27),
            c(42,112,165,212,247,240,219,174,120),
            c(131,171,207,232,247,211,160,97,55),maxColorValue=255),
        rgb(c(64,118,153,194,231,217,166,90,27,0),
            c(0,42,112,165,212,240,219,174,120,68),
            c(75,131,171,207,232,211,160,97,55,27),maxColorValue=255),
        rgb(c(64,118,153,194,231,247,217,166,90,27,0),
            c(0,42,112,165,212,247,240,219,174,120,68),
            c(75,131,171,207,232,247,211,160,97,55,27),maxColorValue=255)
        ),          
    PuBu =  switch(n-2,            
        rgb(c(236,166,43),
            c(231,189,140),
            c(242,219,190),maxColorValue=255),
        rgb(c(241,189,116,5),
            c(238,201,169,112),
            c(246,225,207,176),maxColorValue=255),
        rgb(c(241,189,116,43,4),
            c(238,201,169,140,90),
            c(246,225,207,190,141),maxColorValue=255),
        rgb(c(241,208,166,116,43,4),
            c(238,209,189,169,140,90),
            c(246,230,219,207,190,141),maxColorValue=255),
        rgb(c(241,208,166,116,54,5,3),
            c(238,209,189,169,144,112,78),
            c(246,230,219,207,192,176,123),maxColorValue=255),
        rgb(c(255,236,208,166,116,54,5,3),
            c(247,231,209,189,169,144,112,78),
            c(251,242,230,219,207,192,176,123),maxColorValue=255),
        rgb(c(255,236,208,166,116,54,5,4,2),
            c(247,231,209,189,169,144,112,90,56),
            c(251,242,230,219,207,192,176,141,88),maxColorValue=255)
        ),          
    PuBuGn = switch(n-2,            
        rgb(c(236,166,28),
            c(226,189,144),
            c(240,219,153),maxColorValue=255),
        rgb(c(246,189,103,2),
            c(239,201,169,129),
            c(247,225,207,138),maxColorValue=255),
        rgb(c(246,189,103,28,1),
            c(239,201,169,144,108),
            c(247,225,207,153,89),maxColorValue=255),
        rgb(c(246,208,166,103,28,1),
            c(239,209,189,169,144,108),
            c(247,230,219,207,153,89),maxColorValue=255),
        rgb(c(246,208,166,103,54,2,1),
            c(239,209,189,169,144,129,100),
            c(247,230,219,207,192,138,80),maxColorValue=255),
        rgb(c(255,236,208,166,103,54,2,1),
            c(247,226,209,189,169,144,129,100),
            c(251,240,230,219,207,192,138,80),maxColorValue=255),
        rgb(c(255,236,208,166,103,54,2,1,1),
            c(247,226,209,189,169,144,129,108,70),
            c(251,240,230,219,207,192,138,89,54),maxColorValue=255)
        ),          
    PuOr =  switch(n-2,            
        rgb(c(241,247,153),
            c(163,247,142),
            c(64,247,195),maxColorValue=255),
        rgb(c(230,253,178,94),
            c(97,184,171,60),
            c(1,99,210,153),maxColorValue=255),
        rgb(c(230,253,247,178,94),
            c(97,184,247,171,60),
            c(1,99,247,210,153),maxColorValue=255),
        rgb(c(179,241,254,216,153,84),
            c(88,163,224,218,142,39),
            c(6,64,182,235,195,136),maxColorValue=255),
        rgb(c(179,241,254,247,216,153,84),
            c(88,163,224,247,218,142,39),
            c(6,64,182,247,235,195,136),maxColorValue=255),
        rgb(c(179,224,253,254,216,178,128,84),
            c(88,130,184,224,218,171,115,39),
            c(6,20,99,182,235,210,172,136),maxColorValue=255),
        rgb(c(179,224,253,254,247,216,178,128,84),
            c(88,130,184,224,247,218,171,115,39),
            c(6,20,99,182,247,235,210,172,136),maxColorValue=255),
        rgb(c(127,179,224,253,254,216,178,128,84,45),
            c(59,88,130,184,224,218,171,115,39,0),
            c(8,6,20,99,182,235,210,172,136,75),maxColorValue=255),
        rgb(c(127,179,224,253,254,247,216,178,128,84,45),
            c(59,88,130,184,224,247,218,171,115,39,0),
            c(8,6,20,99,182,247,235,210,172,136,75),maxColorValue=255)
        ),          
    PuRd =  switch(n-2,            
        rgb(c(231,201,221),
            c(225,148,28),
            c(239,199,119),maxColorValue=255),
        rgb(c(241,215,223,206),
            c(238,181,101,18),
            c(246,216,176,86),maxColorValue=255),
        rgb(c(241,215,223,221,152),
            c(238,181,101,28,0),
            c(246,216,176,119,67),maxColorValue=255),
        rgb(c(241,212,201,223,221,152),
            c(238,185,148,101,28,0),
            c(246,218,199,176,119,67),maxColorValue=255),
        rgb(c(241,212,201,223,231,206,145),
            c(238,185,148,101,41,18,0),
            c(246,218,199,176,138,86,63),maxColorValue=255),
        rgb(c(247,231,212,201,223,231,206,145),
            c(244,225,185,148,101,41,18,0),
            c(249,239,218,199,176,138,86,63),maxColorValue=255),
        rgb(c(247,231,212,201,223,231,206,152,103),
            c(244,225,185,148,101,41,18,0,0),
            c(249,239,218,199,176,138,86,67,31),maxColorValue=255)
        ),          
    Purples =   switch(n-2,            
        rgb(c(239,188,117),
            c(237,189,107),
            c(245,220,177),maxColorValue=255),
        rgb(c(242,203,158,106),
            c(240,201,154,81),
            c(247,226,200,163),maxColorValue=255),
        rgb(c(242,203,158,117,84),
            c(240,201,154,107,39),
            c(247,226,200,177,143),maxColorValue=255),
        rgb(c(242,218,188,158,117,84),
            c(240,218,189,154,107,39),
            c(247,235,220,200,177,143),maxColorValue=255),
        rgb(c(242,218,188,158,128,106,74),
            c(240,218,189,154,125,81,20),
            c(247,235,220,200,186,163,134),maxColorValue=255),
        rgb(c(252,239,218,188,158,128,106,74),
            c(251,237,218,189,154,125,81,20),
            c(253,245,235,220,200,186,163,134),maxColorValue=255),
        rgb(c(252,239,218,188,158,128,106,84,63),
            c(251,237,218,189,154,125,81,39,0),
            c(253,245,235,220,200,186,163,143,125),maxColorValue=255)
        ),          
    RdBu =  switch(n-2,            
        rgb(c(239,247,103),
            c(138,247,169),
            c(98,247,207),maxColorValue=255),
        rgb(c(202,244,146,5),
            c(0,165,197,113),
            c(32,130,222,176),maxColorValue=255),
        rgb(c(202,244,247,146,5),
            c(0,165,247,197,113),
            c(32,130,247,222,176),maxColorValue=255),
        rgb(c(178,239,253,209,103,33),
            c(24,138,219,229,169,102),
            c(43,98,199,240,207,172),maxColorValue=255),
        rgb(c(178,239,253,247,209,103,33),
            c(24,138,219,247,229,169,102),
            c(43,98,199,247,240,207,172),maxColorValue=255),
        rgb(c(178,214,244,253,209,146,67,33),
            c(24,96,165,219,229,197,147,102),
            c(43,77,130,199,240,222,195,172),maxColorValue=255),
        rgb(c(178,214,244,253,247,209,146,67,33),
            c(24,96,165,219,247,229,197,147,102),
            c(43,77,130,199,247,240,222,195,172),maxColorValue=255),
        rgb(c(103,178,214,244,253,209,146,67,33,5),
            c(0,24,96,165,219,229,197,147,102,48),
            c(31,43,77,130,199,240,222,195,172,97),maxColorValue=255),
        rgb(c(103,178,214,244,253,247,209,146,67,33,5),
            c(0,24,96,165,219,247,229,197,147,102,48),
            c(31,43,77,130,199,247,240,222,195,172,97),maxColorValue=255)
        ),          
    RdGy =  switch(n-2,            
        rgb(c(239,255,153),
            c(138,255,153),
            c(98,255,153),maxColorValue=255),
        rgb(c(202,244,186,64),
            c(0,165,186,64),
            c(32,130,186,64),maxColorValue=255),
        rgb(c(202,244,255,186,64),
            c(0,165,255,186,64),
            c(32,130,255,186,64),maxColorValue=255),
        rgb(c(178,239,253,224,153,77),
            c(24,138,219,224,153,77),
            c(43,98,199,224,153,77),maxColorValue=255),
        rgb(c(178,239,253,255,224,153,77),
            c(24,138,219,255,224,153,77),
            c(43,98,199,255,224,153,77),maxColorValue=255),
        rgb(c(178,214,244,253,224,186,135,77),
            c(24,96,165,219,224,186,135,77),
            c(43,77,130,199,224,186,135,77),maxColorValue=255),
        rgb(c(178,214,244,253,255,224,186,135,77),
            c(24,96,165,219,255,224,186,135,77),
            c(43,77,130,199,255,224,186,135,77),maxColorValue=255),
        rgb(c(103,178,214,244,253,224,186,135,77,26),
            c(0,24,96,165,219,224,186,135,77,26),
            c(31,43,77,130,199,224,186,135,77,26),maxColorValue=255),
        rgb(c(103,178,214,244,253,255,224,186,135,77,26),
            c(0,24,96,165,219,255,224,186,135,77,26),
            c(31,43,77,130,199,255,224,186,135,77,26),maxColorValue=255)
        ),          
    RdPu =  switch(n-2,            
        rgb(c(253,250,197),
            c(224,159,27),
            c(221,181,138),maxColorValue=255),
        rgb(c(254,251,247,174),
            c(235,180,104,1),
            c(226,185,161,126),maxColorValue=255),
        rgb(c(254,251,247,197,122),
            c(235,180,104,27,1),
            c(226,185,161,138,119),maxColorValue=255),
        rgb(c(254,252,250,247,197,122),
            c(235,197,159,104,27,1),
            c(226,192,181,161,138,119),maxColorValue=255),
        rgb(c(254,252,250,247,221,174,122),
            c(235,197,159,104,52,1,1),
            c(226,192,181,161,151,126,119),maxColorValue=255),
        rgb(c(255,253,252,250,247,221,174,122),
            c(247,224,197,159,104,52,1,1),
            c(243,221,192,181,161,151,126,119),maxColorValue=255),
        rgb(c(255,253,252,250,247,221,174,122,73),
            c(247,224,197,159,104,52,1,1,0),
            c(243,221,192,181,161,151,126,119,106),maxColorValue=255)
        ),          
    Reds =  switch(n-2,            
        rgb(c(254,252,222),
            c(224,146,45),
            c(210,114,38),maxColorValue=255),
        rgb(c(254,252,251,203),
            c(229,174,106,24),
            c(217,145,74,29),maxColorValue=255),
        rgb(c(254,252,251,222,165),
            c(229,174,106,45,15),
            c(217,145,74,38,21),maxColorValue=255),
        rgb(c(254,252,252,251,222,165),
            c(229,187,146,106,45,15),
            c(217,161,114,74,38,21),maxColorValue=255),
        rgb(c(254,252,252,251,239,203,153),
            c(229,187,146,106,59,24,0),
            c(217,161,114,74,44,29,13),maxColorValue=255),
        rgb(c(255,254,252,252,251,239,203,153),
            c(245,224,187,146,106,59,24,0),
            c(240,210,161,114,74,44,29,13),maxColorValue=255),
        rgb(c(255,254,252,252,251,239,203,165,103),
            c(245,224,187,146,106,59,24,15,0),
            c(240,210,161,114,74,44,29,21,13),maxColorValue=255)
        ),          
    RdYlBu = switch(n-2,            
        rgb(c(252,255,145),
            c(141,255,191),
            c(89,191,219),maxColorValue=255),
        rgb(c(215,253,171,44),
            c(25,174,217,123),
            c(28,97,233,182),maxColorValue=255),
        rgb(c(215,253,255,171,44),
            c(25,174,255,217,123),
            c(28,97,191,233,182),maxColorValue=255),
        rgb(c(215,252,254,224,145,69),
            c(48,141,224,243,191,117),
            c(39,89,144,248,219,180),maxColorValue=255),
        rgb(c(215,252,254,255,224,145,69),
            c(48,141,224,255,243,191,117),
            c(39,89,144,191,248,219,180),maxColorValue=255),
        rgb(c(215,244,253,254,224,171,116,69),
            c(48,109,174,224,243,217,173,117),
            c(39,67,97,144,248,233,209,180),maxColorValue=255),
        rgb(c(215,244,253,254,255,224,171,116,69),
            c(48,109,174,224,255,243,217,173,117),
            c(39,67,97,144,191,248,233,209,180),maxColorValue=255),
        rgb(c(165,215,244,253,254,224,171,116,69,49),
            c(0,48,109,174,224,243,217,173,117,54),
            c(38,39,67,97,144,248,233,209,180,149),maxColorValue=255),
        rgb(c(165,215,244,253,254,255,224,171,116,69,49),
            c(0,48,109,174,224,255,243,217,173,117,54),
            c(38,39,67,97,144,191,248,233,209,180,149),maxColorValue=255)
        ),          
    RdYlGn = switch(n-2,            
        rgb(c(252,255,145),
            c(141,255,207),
            c(89,191,96),maxColorValue=255),
        rgb(c(215,253,166,26),
            c(25,174,217,150),
            c(28,97,106,65),maxColorValue=255),
        rgb(c(215,253,255,166,26),
            c(25,174,255,217,150),
            c(28,97,191,106,65),maxColorValue=255),
        rgb(c(215,252,254,217,145,26),
            c(48,141,224,239,207,152),
            c(39,89,139,139,96,80),maxColorValue=255),
        rgb(c(215,252,254,255,217,145,26),
            c(48,141,224,255,239,207,152),
            c(39,89,139,191,139,96,80),maxColorValue=255),
        rgb(c(215,244,253,254,217,166,102,26),
            c(48,109,174,224,239,217,189,152),
            c(39,67,97,139,139,106,99,80),maxColorValue=255),
        rgb(c(215,244,253,254,255,217,166,102,26),
            c(48,109,174,224,255,239,217,189,152),
            c(39,67,97,139,191,139,106,99,80),maxColorValue=255),
        rgb(c(165,215,244,253,254,217,166,102,26,0),
            c(0,48,109,174,224,239,217,189,152,104),
            c(38,39,67,97,139,139,106,99,80,55),maxColorValue=255),
        rgb(c(165,215,244,253,254,255,217,166,102,26,0),
            c(0,48,109,174,224,255,239,217,189,152,104),
            c(38,39,67,97,139,191,139,106,99,80,55),maxColorValue=255)
        ),          
    Set1 =  switch(n-2,            
        rgb(c(228,55,77),
            c(26,126,175),
            c(28,184,74),maxColorValue=255),
        rgb(c(228,55,77,152),
            c(26,126,175,78),
            c(28,184,74,163),maxColorValue=255),
        rgb(c(228,55,77,152,255),
            c(26,126,175,78,127),
            c(28,184,74,163,0),maxColorValue=255),
        rgb(c(228,55,77,152,255,255),
            c(26,126,175,78,127,255),
            c(28,184,74,163,0,51),maxColorValue=255),
        rgb(c(228,55,77,152,255,255,166),
            c(26,126,175,78,127,255,86),
            c(28,184,74,163,0,51,40),maxColorValue=255),
        rgb(c(228,55,77,152,255,255,166,247),
            c(26,126,175,78,127,255,86,129),
            c(28,184,74,163,0,51,40,191),maxColorValue=255),
        rgb(c(228,55,77,152,255,255,166,247,153),
            c(26,126,175,78,127,255,86,129,153),
            c(28,184,74,163,0,51,40,191,153),maxColorValue=255)
        ),          
    Set2 =  switch(n-2,            
        rgb(c(102,252,141),
            c(194,141,160),
            c(165,98,203),maxColorValue=255),
        rgb(c(102,252,141,231),
            c(194,141,160,138),
            c(165,98,203,195),maxColorValue=255),
        rgb(c(102,252,141,231,166),
            c(194,141,160,138,216),
            c(165,98,203,195,84),maxColorValue=255),
        rgb(c(102,252,141,231,166,255),
            c(194,141,160,138,216,217),
            c(165,98,203,195,84,47),maxColorValue=255),
        rgb(c(102,252,141,231,166,255,229),
            c(194,141,160,138,216,217,196),
            c(165,98,203,195,84,47,148),maxColorValue=255),
        rgb(c(102,252,141,231,166,255,229,179),
            c(194,141,160,138,216,217,196,179),
            c(165,98,203,195,84,47,148,179),maxColorValue=255)
        ),          
    Set3 =  switch(n-2, 
        rgb(c(141,255,190),
            c(211,255,186),
            c(199,179,218),maxColorValue=255),
        rgb(c(141,255,190,251),
            c(211,255,186,128),
            c(199,179,218,114),maxColorValue=255),
        rgb(c(141,255,190,251,128),
            c(211,255,186,128,177),
            c(199,179,218,114,211),maxColorValue=255),
        rgb(c(141,255,190,251,128,253),
            c(211,255,186,128,177,180),
            c(199,179,218,114,211,98),maxColorValue=255),
        rgb(c(141,255,190,251,128,253,179),
            c(211,255,186,128,177,180,222),
            c(199,179,218,114,211,98,105),maxColorValue=255),
        rgb(c(141,255,190,251,128,253,179,252),
            c(211,255,186,128,177,180,222,205),
            c(199,179,218,114,211,98,105,229),maxColorValue=255),
        rgb(c(141,255,190,251,128,253,179,252,217),
            c(211,255,186,128,177,180,222,205,217),
            c(199,179,218,114,211,98,105,229,217),maxColorValue=255),
        rgb(c(141,255,190,251,128,253,179,252,217,188),
            c(211,255,186,128,177,180,222,205,217,128),
            c(199,179,218,114,211,98,105,229,217,189),maxColorValue=255),
        rgb(c(141,255,190,251,128,253,179,252,217,188,204),
            c(211,255,186,128,177,180,222,205,217,128,235),
            c(199,179,218,114,211,98,105,229,217,189,197),maxColorValue=255),
        rgb(c(141,255,190,251,128,253,179,252,217,188,204,),
            c(211,255,186,128,177,180,222,205,217,128,235,),
            c(199,179,218,114,211,98,105,229,217,189,197,),maxColorValue=255)
        ),          
    Spectral =  switch(n-2,            
        rgb(c(252,255,153),
            c(141,255,213),
            c(89,191,148),maxColorValue=255),
        rgb(c(215,253,171,43),
            c(25,174,221,131),
            c(28,97,164,186),maxColorValue=255),
        rgb(c(215,253,255,171,43),
            c(25,174,255,221,131),
            c(28,97,191,164,186),maxColorValue=255),
        rgb(c(213,252,254,230,153,50),
            c(62,141,224,245,213,136),
            c(79,89,139,152,148,189),maxColorValue=255),
        rgb(c(213,252,254,255,230,153,50),
            c(62,141,224,255,245,213,136),
            c(79,89,139,191,152,148,189),maxColorValue=255),
        rgb(c(213,244,253,254,230,171,102,50),
            c(62,109,174,224,245,221,194,136),
            c(79,67,97,139,152,164,165,189),maxColorValue=255),
        rgb(c(213,244,253,254,255,230,171,102,50),
            c(62,109,174,224,255,245,221,194,136),
            c(79,67,97,139,191,152,164,165,189),maxColorValue=255),
        rgb(c(158,213,244,253,254,230,171,102,50,94),
            c(1,62,109,174,224,245,221,194,136,79),
            c(66,79,67,97,139,152,164,165,189,162),maxColorValue=255),
        rgb(c(158,213,244,253,254,255,230,171,102,50,94),
            c(1,62,109,174,224,255,245,221,194,136,79),
            c(66,79,67,97,139,191,152,164,165,189,162),maxColorValue=255)
        ),          
    YlGn =  switch(n-2,            
        rgb(c(247,173,49),
            c(252,221,163),
            c(185,142,84),maxColorValue=255),
        rgb(c(255,194,120,35),
            c(255,230,198,132),
            c(204,153,121,67),maxColorValue=255),
        rgb(c(255,194,120,49,0),
            c(255,230,198,163,104),
            c(204,153,121,84,55),maxColorValue=255),
        rgb(c(255,217,173,120,49,0),
            c(255,240,221,198,163,104),
            c(204,163,142,121,84,55),maxColorValue=255),
        rgb(c(255,217,173,120,65,35,0),
            c(255,240,221,198,171,132,90),
            c(204,163,142,121,93,67,50),maxColorValue=255),
        rgb(c(255,247,217,173,120,65,35,0),
            c(255,252,240,221,198,171,132,90),
            c(229,185,163,142,121,93,67,50),maxColorValue=255),
        rgb(c(255,247,217,173,120,65,35,0,0),
            c(255,252,240,221,198,171,132,104,69),
            c(229,185,163,142,121,93,67,55,41),maxColorValue=255)
        ),          
    YlGnBu = switch(n-2,            
        rgb(c(237,127,44),
            c(248,205,127),
            c(177,187,184),maxColorValue=255),
        rgb(c(255,161,65,34),
            c(255,218,182,94),
            c(204,180,196,168),maxColorValue=255),
        rgb(c(255,161,65,44,37),
            c(255,218,182,127,52),
            c(204,180,196,184,148),maxColorValue=255),
        rgb(c(255,199,127,65,44,37),
            c(255,233,205,182,127,52),
            c(204,180,187,196,184,148),maxColorValue=255),
        rgb(c(255,199,127,65,29,34,12),
            c(255,233,205,182,145,94,44),
            c(204,180,187,196,192,168,132),maxColorValue=255),
        rgb(c(255,237,199,127,65,29,34,12),
            c(255,248,233,205,182,145,94,44),
            c(217,177,180,187,196,192,168,132),maxColorValue=255),
        rgb(c(255,237,199,127,65,29,34,37,8),
            c(255,248,233,205,182,145,94,52,29),
            c(217,177,180,187,196,192,168,148,88),maxColorValue=255)
        ),          
    YlOrBr = switch(n-2,            
        rgb(c(255,254,217),
            c(247,196,95),
            c(188,79,14),maxColorValue=255),
        rgb(c(255,254,254,204),
            c(255,217,153,76),
            c(212,142,41,2),maxColorValue=255),
        rgb(c(255,254,254,217,153),
            c(255,217,153,95,52),
            c(212,142,41,14,4),maxColorValue=255),
        rgb(c(255,254,254,254,217,153),
            c(255,227,196,153,95,52),
            c(212,145,79,41,14,4),maxColorValue=255),
        rgb(c(255,254,254,254,236,204,140),
            c(255,227,196,153,112,76,45),
            c(212,145,79,41,20,2,4),maxColorValue=255),
        rgb(c(255,255,254,254,254,236,204,140),
            c(255,247,227,196,153,112,76,45),
            c(229,188,145,79,41,20,2,4),maxColorValue=255),
        rgb(c(255,255,254,254,254,236,204,153,102),
            c(255,247,227,196,153,112,76,52,37),
            c(229,188,145,79,41,20,2,4,6),maxColorValue=255)
        ),          
    YlOrRd = switch(n-2,            
        rgb(c(255,254,240),
            c(237,178,59),
            c(160,76,32),maxColorValue=255),
        rgb(c(255,254,253,227),
            c(255,204,141,26),
            c(178,92,60,28),maxColorValue=255),
        rgb(c(255,254,253,240,189),
            c(255,204,141,59,0),
            c(178,92,60,32,38),maxColorValue=255),
        rgb(c(255,254,254,253,240,189),
            c(255,217,178,141,59,0),
            c(178,118,76,60,32,38),maxColorValue=255),
        rgb(c(255,254,254,253,252,227,177),
            c(255,217,178,141,78,26,0),
            c(178,118,76,60,42,28,38),maxColorValue=255),
        rgb(c(255,255,254,254,253,252,227,177),
            c(255,237,217,178,141,78,26,0),
            c(204,160,118,76,60,42,28,38),maxColorValue=255),
        rgb(c(255,255,254,254,253,252,227,189,128),
            c(255,237,217,178,141,78,26,0,0),
            c(204,160,118,76,60,42,28,38,38),maxColorValue=255)
        ))
}                        

display.brewer.pal<-function(n,name){
   if(!(name %in% namelist)){
   stop(paste(name,"is not a valid palette name for brewer.pal\n"))
   }   
   if(n<3){ 
   warning("minimal value for n is 3, displaying requested palette with 3 different levels\n")
   return(display.brewer.pal(3,name))
   }
   if(n>maxcolors[which(name==namelist)]){
   warning(paste("n too large, allowed maximum for palette",name,"is",maxcolors[which(name==namelist)]),
        "\nDisplaying the palette you asked for with that many colors\n")
   return(display.brewer.pal(maxcolors[which(name==namelist)],name))
   }


   if(length(which(name==quallist))>0) palattr<-"(qualitative)"
   if(length(which(name==divlist))>0) palattr<-"(divergent)"
   if(length(which(name==seqlist))>0) palattr<-"(sequential)"
    image(1:n,1,as.matrix(1:n),col=brewer.pal(n,name),
       xlab=paste(name,palattr),ylab="",xaxt="n",yaxt="n",bty="n")

}

display.brewer.all <-
    function (n=NULL, type="all", select=NULL, exact.n=TRUE)
{
    gaplist <- ""

    totallist <- c(divlist, gaplist, quallist,gaplist, seqlist)
    gapnum <- max(c(divnum,qualnum,seqnum))
    totnum <- c(divnum, gapnum, qualnum, gapnum, seqnum)
    if (!(type %in% c("div","qual","seq","all"))) {
        stop(paste(type, "is not a valid name for a color list\n"))
    }
    colorlist <- switch(type, div=divlist,
                        qual=quallist, seq=seqlist,
                        all=totallist)
    maxnum <- switch(type, div=divnum,
                     qual=qualnum,
                     seq=seqnum,
                     all=totnum)
    if(!is.null(select)){colorlist <- colorlist[select]
                         maxnum <- maxnum[select]
                         if(any(is.na(colorlist)))
                             stop(paste("Illegal value(s) of select: ",
                                        paste(select[is.na(colorlist)],
                                              collapse=" ")))
                     }
    palattr <-  switch(type,  qual="qualitative",  div
                       ="divergent", seq="sequential",
                       all="qualitative+divergent+sequential")
    if(is.null(n))n <- maxnum
    if(length(n)==1)n <- rep(n, length(colorlist))
    if(exact.n){
        keep <- n<=maxnum
        colorlist <- colorlist[keep]
        n <- n[keep]
        maxnum <- maxnum[keep]
    }
    if (any(n < 3) | exact.n & any(n>maxnum)|
        length(n)!=length(colorlist)){
        warning("Illegal vector of color numbers")
        print(paste(n, collapse=" "))
    }
    n[n<3] <- 3
    n[n>maxnum] <- maxnum[n>maxnum]
    nr <- length(colorlist)
    nc <- max(n)
    ylim <- c(0,nr)
    oldpar <- par(mgp=c(2,0.25,0))
    on.exit(par(oldpar))
    plot(1,1,xlim=c(0,nc),ylim=ylim,type="n", axes=FALSE, bty="n",
         xlab="",ylab="")
    for(i in 1:nr)
    {nj <- n[i]
     if(colorlist[i]=="")next
     shadi <- brewer.pal(nj, colorlist[i])
     rect(xleft=0:(nj-1), ybottom=i-1, xright=1:nj, ytop=i-0.2, col=shadi,
          border="light grey")
 }
    text(rep(-0.1,nr),(1:nr)-0.6, labels=colorlist, xpd=TRUE, adj=1)
}

