% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/RDML.init.R
\docType{methods}
\name{new}
\alias{RDML.new}
\alias{new}
\title{Creates new instance of \code{RDML} class object}
\arguments{
\item{filename}{\code{string} -- path to RDML file}

\item{conditions.sep}{separator for condition defined at sample name}
}
\description{
This function has been designed to import data from RDML v1.1 and v1.2 format files
}
\section{Warning}{
 Although the format RDML claimed as data exchange format,
  the specific implementation of the format at devices from real
  manufacturers differ significantly. Currently this function is checked
  against RDML data from devices: \emph{Bio-Rad CFX96}, \emph{Roche
  LightCycler 96} and \emph{Applied Biosystems StepOne}.
}
\examples{
\dontrun{
## Import from RDML file
PATH <- path.package("RDML")
filename <- paste(PATH, "/extdata/", "lc96_bACTXY.rdml", sep ="")
lc96 <- RDML$new(filename)

## Some kind of overview for lc96
lc96$AsTable(name.pattern = sample[[react$sample$id]]$description)
lc96$AsDendrogram()
}
}
\author{
Konstantin A. Blagodatskikh <k.blag@yandex.ru>, Stefan Roediger
  <stefan.roediger@hs-lausitz.de>, Michal Burdukiewicz
  <michalburdukiewicz@gmail.com>
}

