% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/RDML.SetFData.R
\docType{methods}
\name{RDML.SetFData}
\alias{RDML.SetFData}
\title{Sets fluorescence data vectors to \code{RDML} object}
\arguments{
\item{data}{\code{matrix} that contains in the first column constant data for all fluorescence vectors (i.e. cycle numbers or temperature)
and fluorescence values in the following columns. The column name is the name of constant data.
Names of other column are \code{fdata.names} (links to rows at \code{description}). Name of
matrix passed to param becomes type of data.}

\item{description}{output from \code{AsTable} function that describes fluorescence data.}

\item{fdata.type}{'adp' for qPCR, 'mdp' for melting data.}
}
\description{
Sets fluorescence data vectors to \code{RDML} object for specified method
of experiment.
}
\examples{
\dontrun{
PATH <- path.package("RDML")
filename <- paste0(PATH, "/extdata/", "stepone_std.rdml")
cfx96 <- RDML$new(filename)
## Use plotCurves function from the chipPCR package to
## get an overview of the amplification curves
library(chipPCR)
## Extract all qPCR data
tab <- cfx96$AsTable()
tab2 <- tab
tab2$run.id <- "cpp"
cfx96.qPCR <- cfx96$GetFData(tab)
cpp <- cbind(cyc = cfx96.qPCR[, 1],
 apply(cfx96.qPCR[, -1], 2,
   function(y) CPP(x = cfx96.qPCR[, 1], y = y)$y.norm))
cfx96$SetFData(cpp, tab2)
library(ggplot2)
library(gridExtra)
cfx96.gg <- cfx96$GetFData(tab, long.table = TRUE)
cpp.gg <- cfx96$GetFData(tab2,
                         long.table = TRUE)
plot1 <- ggplot(cfx96.gg, aes(x = cyc, y = fluo,
                group=fdata.name)) +
                 geom_line() +
                 ggtitle("Raw data")
plot2 <- ggplot(cpp.gg, aes(x = cyc, y = fluo,
                group=fdata.name)) +
                 geom_line() +
                 ggtitle("CPP processed data")
grid.arrange(plot1, plot2, nrow=2)
}
}

