% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rd_export.R
\name{rd_export}
\alias{rd_export}
\title{Exporting the dataset of the queries}
\usage{
rd_export(
  ...,
  queries = NULL,
  column = NULL,
  sheet_name = NULL,
  path = NULL,
  password = NULL
)
}
\arguments{
\item{...}{List containing the data frame of queries. It may be the output of the `rd_query` or `rd_event` functions.}

\item{queries}{Data frame containing the identified queries. If the list is given, this argument is not required.}

\item{column}{Character element specifying the column containing the link of each query.}

\item{sheet_name}{Character element specifying the sheet name of the resulting xlsx file.}

\item{path}{Character element specifying the file path to save the xlsx file. If `NULL`, the file is created in the current working directory.}

\item{password}{String with the password to protect the worksheet and prevent others from making changes.}
}
\value{
An xlsx file containing all the queries and, if available, hyperlinks to each one of them.
}
\description{
This function allows you to export the previously identified queries to an xlsx file.
}
