% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{reidsfunction_genebygene}
\alias{reidsfunction_genebygene}
\title{"reidsfunction_genebygene"}
\usage{
reidsfunction_genebygene(file_name, file_pos, line_length, nsim,
  informativeCalls = TRUE, rho = 0.5, Low_AllSamples, Location)
}
\arguments{
\item{file_name}{The name of the pivot transformed .csv file.}

\item{file_pos}{The position in the file where to start reading.}

\item{line_length}{The length of the line to read.}

\item{nsim}{The number of iterations to perform.}

\item{informativeCalls}{Logical. Should the I/NI calls method be perform before applying the REIDS model?}

\item{rho}{The threshold for filtering in the I/NI calls method. Probesets with scores higher than rho are kept.}

\item{Low_AllSamples}{A character vector containing the probe sets which are not DABG in all samples.}

\item{Location}{A character string indication the place where the output should be saved.}
}
\value{
An .RData file for each gene with the values returned by the iniREIDS and REIDS functions.
}
\description{
The reidsfunction_genebygene performs the REIDS model and is an internal function of the REIDSFunction. The function calls on the pivot transformed .csv file and transforms the read lines into a data frame on which the REIDS model is performed.
}
