/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.ErlangDist;
import umontreal.iro.lecuyer.probdist.ExponentialDist;
import umontreal.iro.lecuyer.randvar.ErlangGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class ErlangConvolutionGen
extends ErlangGen {
    private int k;
    private double lambda;

    public ErlangConvolutionGen(RandomStream randomStream, ErlangDist erlangDist) {
        super(randomStream, erlangDist);
        this.k = erlangDist.getK();
        this.lambda = erlangDist.getLambda();
    }

    public double nextDouble() {
        return ErlangConvolutionGen.convolution(this.stream, this.k, this.lambda);
    }

    public static double nextDouble(RandomStream randomStream, int n, double d) {
        return ErlangConvolutionGen.convolution(randomStream, n, d);
    }

    private static double convolution(RandomStream randomStream, int n, double d) {
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            d2 += ExponentialDist.inverseF(d, randomStream.nextDouble());
        }
        return d2;
    }
}

