% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_s3_multilevel.R
\name{predict.rendo.multilevel}
\alias{predict.rendo.multilevel}
\title{Predict method for Multilevel GMM Estimations}
\usage{
\method{predict}{rendo.multilevel}(object, newdata, model = c("REF",
  "FE_L2", "FE_L3", "GMM_L2", "GMM_L3"), ...)
}
\arguments{
\item{object}{Object of class inheriting from "rendo.multilevel"}

\item{newdata}{An optional data frame in which to look for variables with which to predict.
If omitted, the fitted values for the specified model are returned.}

\item{model}{character string to indicate for which fitted model predictions are made.
Possible values are: \code{"REF", "FE_L2", "FE_L3", "GMM_L2"}, or \code{"GMM_L3"}.}

\item{...}{ignored, for consistency with the generic function.}
}
\value{
\code{predict.rendo.multilevel} produces a vector of predictions
}
\description{
Predicted values based on multilevel models employing the GMM approach for hierarchical data with
endogenous regressors.
}
\examples{
data("dataMultilevelIV")

# Two levels
res.ml.L2 <- multilevelIV(y ~ X11 + X12 + X13 + X14 + X15 + X21 + X22 + X23 + X24 + X31 +
                          X32 + X33 + (1|SID) | endo(X15),
                          data = dataMultilevelIV, verbose = FALSE)
predict(res.ml.L2, model = "FE_L2")

# using the data used for fitting also for predicting,
#    correctly results in fitted values
all.equal(predict(res.ml.L2, dataMultilevelIV, model = "GMM_L2"),
          fitted(res.ml.L2, model = "GMM_L2")) # TRUE

}
\seealso{
The model fitting function \code{\link[REndo:multilevelIV]{multilevelIV}}
}
