\name{BLASTdata}
\alias{BLASTdata}
\docType{data}
\title{ Example data set for BLAST data }
\description{
  This is an example data set for BLAST data generated with standalone BLAST from NCBI. 
}
\usage{data(RFLPdata)}
\format{
  A data frame with 737 observations on the following four variables
  \describe{
    \item{\code{query.id}}{character: sequence identifier. }
    \item{\code{subject.id}}{character: subject identifier. }
    \item{\code{identity}}{numeric: identity between sequences (in percent). }
    \item{\code{alignment.length}}{integer: number of nucleotides. }
    \item{\code{mismatches}}{integer: number of mismatches. }
    \item{\code{gap.opens}}{integer: number of gaps. }
    \item{\code{q.start}}{integer: query sequence start. }
    \item{\code{q.end}}{integer: query sequence end. }
    \item{\code{s.start}}{integer: subject sequence start. }
    \item{\code{s.end}}{integer: subject sequence end. }
    \item{\code{evalue}}{numeric: evalue. }
    \item{\code{bit.score}}{numeric: score value. }
  }
}
\details{
  The data was generated with standalone BLAST from NCBI.
  Pairwise similarities of DNA sequences are calculated among all sequences 
  to analyse applying Standalone Blast with the parameters -m 8 -r 2 -G 5 -E 2.
  
  Alternatively data can be generated with "local BLAST" implemented in 
  BioEdit v7.0.9 using the additional parameters -m 8 -r 2 -G 5 -E 2 and 
  by selecting "open output" and "tabular output".
}
\source{
  The data set was generated by F. Flessa.
}
\references{
  Standalone Blast download: \url{https://ftp.ncbi.nlm.nih.gov/blast/executables/blast+/LATEST/}
  
  Blast News: \url{https://blast.ncbi.nlm.nih.gov/Blast.cgi?CMD=Web&PAGE_TYPE=BlastNews}
  
  BioEdit: \url{https://bioedit.software.informer.com/}
  
  Flessa, F., Kehl, A., Kohl, M.
  Analysing diversity and community structures using PCR-RFLP: a new software application.
  Molecular Ecology Resources 2013 Jul; 13(4):726-33. 
}
\examples{
data(BLASTdata)
str(BLASTdata)
}
\keyword{datasets}
