% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemSigSelect.R
\name{chemSigSelect}
\alias{chemSigSelect}
\title{Chemical Data Selection within the Floating Percentile Model}
\usage{
chemSigSelect(data, paramList, plot = FALSE, ...)
}
\arguments{
\item{data}{data.frame containing, at a minimum, chemical concentrations as columns and a logical \code{Hit} column classifying toxicity}

\item{paramList}{character vector naming columns of \code{data} containing concentrations}

\item{plot}{logical value indicating whether or not to generate figures comparing concentrations between subsets where \code{Hit == TRUE} and \code{Hit == FALSE} (default = \code{FALSE})}

\item{...}{additional arguments passed to \code{chemSig}}
}
\value{
list of two data.frames (\code{"sig"} and \code{"nonsig"}), \code{chemSigSelect} class object
}
\description{
Generate a dataset of concentrationso for chemicals with significantly higher concentrations
among toxic samples by comparison to non-toxic samples
}
\details{
\code{chemSigSelect} is used within \code{FPM} to quickly run \code{chemSig} and export concentrations from \code{data} for the
significant chemicals to include in the floating percentile model algorithm. Results are exported in list with two data.frames, separated into chemicals that were significant (\code{"sig"}) and non-significant (\code{"nonsig"})
For information on \code{data} and \code{paramList}, see details of \code{?FPM}.

If \code{plot = TRUE}, then a series of plots will be exported comparing the Hit/No-hit data subsets for all chemicals in \code{paramList}. Plots with blue lines are generated from
significant chemicals, and plots with green lines are generated from non-significant chemicals. The user currently has only
limited control over graphical parameters of plots, and attempts to change graphical parameters are likely to cause errors.
}
\examples{
paramList = c("Cd", "Cu", "Fe", "Mn", "Ni", "Pb", "Zn")
chemSigSelect(data = h.tristate, paramList = paramList)$sig[1:6,]
chemSigSelect(data = h.tristate, paramList = paramList, testType = "p")$sig[1:6,]
}
\seealso{
plot.chemSigSelect, FPM, chemSig
}
