% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RFMCcv.R
\name{rfMCCVPerf}
\alias{rfMCCVPerf}
\title{Extracting average accuracy and recall of a list of Random Forest models}
\usage{
rfMCCVPerf(model_list)
}
\arguments{
\item{model_list}{a list of different Random Forest models}
}
\value{
a list of the two elements: \itemize{
\item avg_accuracy the average accuracy
\item avg_recall the average recall
}
}
\description{
This function provides the average accuracy and the recall of a list of Random Forest models
}
\examples{
## data(cachexiaData)
## params <- list(ntrees = 500, ref_level = levels(cachexiaData[,2])[1] )
## mccv_obj <- rfMCCV(cachexiaData, nsplits = 5, test_prop = 1/3, opt_params = params)
## models <- mccv_obj$models
## res <- rfMCCVPerf(models)
}
\author{
Piergiorgio Palla
}

