/*
 * Decompiled with CFR 0.152.
 */
package freak.core.modulesupport.inspector;

import freak.core.graph.Operator;
import freak.core.modulesupport.Module;
import freak.core.modulesupport.PropertyManager;
import freak.core.modulesupport.inspector.ColorEditor;
import freak.core.modulesupport.inspector.ColorRenderer;
import freak.core.modulesupport.inspector.CustomizableInspector;
import freak.core.modulesupport.inspector.CustomizableInspectorTable;
import freak.core.modulesupport.inspector.DoubleArrayEditor;
import freak.core.modulesupport.inspector.DoubleArrayRenderer;
import freak.core.modulesupport.inspector.StringArrayEditor;
import freak.core.modulesupport.inspector.StringArrayRenderer;
import freak.core.modulesupport.inspector.StringArrayWrapper;
import freak.core.parametercontroller.ParameterController;
import freak.gui.CheckBoxDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class StandardInspectorFactory {
    private static boolean parameterControllerDependencyWarningAcknowledged = false;

    public static CustomizableInspector getStandardInspectorFor(final Module module) {
        JTextArea textArea = new JTextArea();
        textArea.setEditable(false);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setToolTipText("Here you can read the description of the selected property.");
        String[] pNames = PropertyManager.getListOfPropertyNames(module);
        int pCount = pNames.length;
        Arrays.sort(pNames, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (!(o1 instanceof String) || !(o2 instanceof String)) {
                    return 0;
                }
                String descr1 = PropertyManager.getShortDescriptionFor(module, (String)o1);
                String descr2 = PropertyManager.getShortDescriptionFor(module, (String)o2);
                return descr1.compareTo(descr2);
            }
        });
        String[] pLongDescr = new String[pCount];
        Object[][] tableData = new Object[pCount][2];
        int i = 0;
        while (i < pCount) {
            try {
                tableData[i][1] = PropertyManager.getProperty(module, pNames[i]);
                tableData[i][0] = PropertyManager.getShortDescriptionFor(module, pNames[i]);
                pLongDescr[i] = PropertyManager.getLongDescriptionFor(module, pNames[i]);
            }
            catch (UnsupportedOperationException e) {
                String[] pNamesNew = new String[--pCount];
                if (i > 0) {
                    System.arraycopy(pNames, 0, pNamesNew, 0, i);
                }
                System.arraycopy(pNames, i + 1, pNamesNew, i, pNames.length - i - 1);
                String[] pLongDescrNew = new String[pCount];
                if (i > 0) {
                    System.arraycopy(pLongDescr, 0, pLongDescrNew, 0, i);
                }
                Object[][] tableDataNew = new Object[pCount][2];
                if (i > 0) {
                    System.arraycopy(tableData, 0, tableDataNew, 0, i);
                }
                pNames = pNamesNew;
                tableData = tableDataNew;
                pLongDescr = pLongDescrNew;
                --i;
            }
            ++i;
        }
        StandardInspectorFactory standardInspectorFactory = new StandardInspectorFactory();
        standardInspectorFactory.getClass();
        final StandardInspectorTableModel tm = standardInspectorFactory.new StandardInspectorTableModel(tableData, module, pNames, pLongDescr, textArea);
        StandardInspectorFactory standardInspectorFactory2 = new StandardInspectorFactory();
        standardInspectorFactory2.getClass();
        StandardInspectorTable table = standardInspectorFactory2.new StandardInspectorTable(tm, textArea, pLongDescr);
        table.setPreferredScrollableViewportSize(table.getPreferredSize());
        tm.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                int i = e.getFirstRow();
                while (i <= e.getLastRow()) {
                    StandardInspectorFactory.checkParameterControllerDependencies(module, tm.getPropertyName(i));
                    ++i;
                }
            }
        });
        CustomizableInspector inspector = new CustomizableInspector(table, module);
        inspector.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.fill = 1;
        inspector.add((Component)new JScrollPane(table), gridBagConstraints);
        inspector.customize(Color.class, new ColorRenderer(), new ColorEditor());
        inspector.customize(Double[].class, new DoubleArrayRenderer(), new DoubleArrayEditor());
        inspector.customize(StringArrayWrapper.class, new StringArrayRenderer(), new StringArrayEditor());
        JScrollPane scrollPane = new JScrollPane(textArea);
        scrollPane.setMinimumSize(new Dimension(10, 50));
        scrollPane.setPreferredSize(new Dimension(10, 50));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        inspector.add((Component)scrollPane, gridBagConstraints);
        return inspector;
    }

    private static void checkParameterControllerDependencies(Object obj, String propName) {
        Operator operator;
        List concurrentControllers;
        if (!parameterControllerDependencyWarningAcknowledged && obj instanceof Operator && (concurrentControllers = (operator = (Operator)obj).getOperatorGraph().getParameterControllersForProperty(operator, propName)).size() > 0) {
            ParameterController[] controllers = new ParameterController[concurrentControllers.size()];
            concurrentControllers.toArray(controllers);
            Arrays.sort(controllers, new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (!(o1 instanceof ParameterController) || !(o2 instanceof ParameterController)) {
                        return 0;
                    }
                    return ((ParameterController)o1).getName().compareTo(((ParameterController)o2).getName());
                }
            });
            String descr = PropertyManager.getShortDescriptionFor(operator, propName);
            StringBuffer s = new StringBuffer("The property " + descr + " is controlled by the following parameter controller" + (controllers.length > 1 ? "s" : "") + ":\n");
            int i = 0;
            while (i < controllers.length) {
                s.append("\n    " + controllers[i].getName());
                ++i;
            }
            s.append("\n\nNote that your input might be overwritten by the controller" + (controllers.length > 1 ? "s" : "") + ".");
            CheckBoxDialog dialog = new CheckBoxDialog(null, true, s.toString(), "Warning", "don't show this warning again");
            dialog.setLocationRelativeTo(null);
            dialog.setVisible(true);
            parameterControllerDependencyWarningAcknowledged = dialog.isCheckBoxSelected();
        }
    }

    public class StandardInspectorTableModel
    extends AbstractTableModel {
        protected Object[][] data;
        protected String[] pNames;
        protected Object propContainer;
        protected String[] pLongDescr;
        protected JTextArea textArea;

        public StandardInspectorTableModel(Object[][] data, Object propContainer, String[] pNames, String[] pLongDescr, JTextArea textArea) {
            this.data = data;
            this.propContainer = propContainer;
            this.pNames = pNames;
            this.pLongDescr = pLongDescr;
            this.textArea = textArea;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        public void setValueAt(Object value, int row, int col) {
            String propName = this.pNames[row];
            Class propType = PropertyManager.getPropertyType(this.propContainer, propName);
            try {
                if (PropertyManager.assignableFrom(propType, Float.class)) {
                    PropertyManager.setProperty(this.propContainer, propName, new Float((String)value));
                } else if (PropertyManager.assignableFrom(propType, Double.class)) {
                    PropertyManager.setProperty(this.propContainer, propName, new Double((String)value));
                } else if (PropertyManager.assignableFrom(propType, Byte.class)) {
                    PropertyManager.setProperty(this.propContainer, propName, new Byte((String)value));
                } else if (PropertyManager.assignableFrom(propType, Integer.class)) {
                    PropertyManager.setProperty(this.propContainer, propName, new Integer((String)value));
                } else if (PropertyManager.assignableFrom(propType, String.class)) {
                    PropertyManager.setProperty(this.propContainer, propName, value);
                } else if (PropertyManager.assignableFrom(propType, Boolean.class)) {
                    PropertyManager.setProperty(this.propContainer, propName, value);
                } else if (PropertyManager.assignableFrom(propType, Double.class)) {
                    PropertyManager.setProperty(this.propContainer, propName, new Double((String)value));
                } else if (PropertyManager.assignableFrom(propType, Long.class)) {
                    PropertyManager.setProperty(this.propContainer, propName, new Long((String)value));
                } else if (PropertyManager.assignableFrom(propType, Short.class)) {
                    PropertyManager.setProperty(this.propContainer, propName, new Short((String)value));
                } else {
                    PropertyManager.setProperty(this.propContainer, propName, value);
                }
            }
            catch (IllegalArgumentException e) {
                System.out.println("Error converting input: " + e);
            }
            value = PropertyManager.getProperty(this.propContainer, propName);
            if (value != this.data[row][col]) {
                this.updateAllFields(row);
            }
        }

        protected void updateAllFields(int updatedRow) {
            this.updateAllFields();
            this.textArea.setText(this.pLongDescr[updatedRow]);
        }

        public void updateAllFields() {
            int i = 0;
            while (i < this.pNames.length) {
                Object value;
                String sDescr = PropertyManager.getShortDescriptionFor(this.propContainer, this.pNames[i]);
                if (!sDescr.equals(this.data[i][0])) {
                    this.data[i][0] = sDescr;
                    this.fireTableCellUpdated(i, 0);
                }
                if (!(value = PropertyManager.getProperty(this.propContainer, this.pNames[i])).equals(this.data[i][1])) {
                    this.data[i][1] = value;
                    this.fireTableCellUpdated(i, 1);
                }
                this.pLongDescr[i] = PropertyManager.getLongDescriptionFor(this.propContainer, this.pNames[i]);
                ++i;
            }
        }

        public int getRowCount() {
            return this.data.length;
        }

        public int getColumnCount() {
            return 2;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.data[rowIndex][columnIndex];
        }

        protected String getPropertyName(int row) {
            return this.pNames[row];
        }

        public String getColumnName(int column) {
            return column == 0 ? "Property" : "Value";
        }
    }

    class StandardInspectorTable
    extends CustomizableInspectorTable {
        public StandardInspectorTable(TableModel dm, JTextArea textArea, String[] propDescriptions) {
            super(dm);
            this.setSelectionMode(0);
            ListSelectionModel rowSM = this.getSelectionModel();
            rowSM.addListSelectionListener(new SelectionListener(textArea, propDescriptions));
        }

        class SelectionListener
        implements ListSelectionListener {
            protected JTextArea textArea;
            protected String[] propDescriptions;

            public SelectionListener(JTextArea textArea, String[] propDescriptions) {
                this.textArea = textArea;
                this.propDescriptions = propDescriptions;
            }

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    int row = lsm.getMinSelectionIndex();
                    this.textArea.setText(this.propDescriptions[row]);
                }
            }
        }
    }
}

