/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.bitstring;

import freak.core.control.Schedule;
import freak.core.fitness.AbstractStaticMultiObjectiveFitnessFunction;
import freak.core.population.Genotype;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.module.searchspace.BitString;
import freak.module.searchspace.BitStringGenotype;
import java.util.BitSet;
import java.util.Iterator;

public class LOTZ
extends AbstractStaticMultiObjectiveFitnessFunction {
    public LOTZ(Schedule schedule) {
        super(schedule);
    }

    protected double[] evaluate(Genotype genotype) {
        BitSet bs = ((BitStringGenotype)genotype).getBitSet();
        int lo = 0;
        int tz = 0;
        int dimension = ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        int k = 0;
        while (k < dimension) {
            if (!bs.get(k)) break;
            ++lo;
            ++k;
        }
        k = dimension - 1;
        while (k >= 0) {
            if (bs.get(k)) break;
            ++tz;
            --k;
        }
        double[] result = new double[]{lo, tz};
        return result;
    }

    public boolean containsParetoFront(IndividualList list) {
        int dimension = ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        if (list.size() < dimension + 1) {
            return false;
        }
        boolean[] exists = new boolean[dimension + 1];
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Individual ind = (Individual)it.next();
            double[] fitness = this.evaluate(ind, null);
            if (fitness[0] + fitness[1] != (double)dimension) continue;
            exists[(int)fitness[0]] = true;
        }
        int i = 0;
        while (i < dimension + 1) {
            if (!exists[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int getDimensionOfObjectiveSpace() {
        return 2;
    }

    public String getName() {
        return "LOTZ";
    }

    public String getDescription() {
        return "Leading Ones - Trailing Zeroes\nThe objectives are to increase both the number of leading ones and the number of trailing zeroes. The first component of the fitness vector is the number of leading ones and the second component is the number of trailing zeroes.";
    }
}

