/*
 * Decompiled with CFR 0.152.
 */
package freak.gui.scheduleeditor;

import freak.core.control.Batch;
import freak.core.control.BatchList;
import freak.core.control.Schedule;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.Configuration;
import freak.core.modulesupport.Module;
import java.util.NoSuchElementException;
import javax.swing.table.AbstractTableModel;

public class BatchTableModel
extends AbstractTableModel {
    final String[] columnNames = new String[]{"Runs", "Search Space", "Fitness", "Population", "Status"};
    private Schedule schedule;
    private BatchList batchList;

    public BatchTableModel(Schedule schedule) {
        this.schedule = schedule;
        this.batchList = schedule.getBatchList();
    }

    private String getBatchConfigStringOf(Module module, Batch batch) {
        String returnString;
        if (module == null) {
            returnString = "<no object>";
        } else if (module instanceof Configurable) {
            try {
                Configuration conf = batch.getConfiguration((Configurable)module);
                returnString = conf.getDescription();
            }
            catch (NoSuchElementException e) {
                returnString = "<no config>";
            }
        } else {
            returnString = "<not configurable>";
        }
        return returnString;
    }

    private String getSearchSpaceConfig(Batch batch) {
        return this.getBatchConfigStringOf(this.schedule.getPhenotypeSearchSpace(), batch);
    }

    private String getFitnessConfig(Batch batch) {
        return this.getBatchConfigStringOf(this.schedule.getRealFitnessFunction(), batch);
    }

    private String getInitializationConfig(Batch batch) {
        return this.getBatchConfigStringOf(this.schedule.getInitialization(), batch);
    }

    public int getRowCount() {
        return this.batchList.size();
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Batch batch = this.batchList.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return new Integer(batch.getRuns());
            }
            case 1: {
                return this.getSearchSpaceConfig(batch);
            }
            case 2: {
                return this.getFitnessConfig(batch);
            }
            case 3: {
                return this.getInitializationConfig(batch);
            }
        }
        if (batch.isFinished()) {
            return "finished";
        }
        if (batch.isStarted()) {
            return "running";
        }
        return "coming up";
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }
}

