/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.pointset;

import freak.core.population.Genotype;
import freak.module.fitness.pointset.AbstractAdjust;
import freak.module.fitness.pointset.AbstractRobustRegressionFitness;
import freak.module.fitness.pointset.util.ResidualContainer;
import freak.module.fitness.pointset.util.ResidualHyperPlane;
import freak.module.searchspace.PointSet;
import freak.module.searchspace.PointSetGenotype;
import java.util.Arrays;

public class LTSAdjust
extends AbstractAdjust {
    public void adjust(AbstractRobustRegressionFitness toBeAdjusted, Genotype genotype) {
        Object[] res = toBeAdjusted.getResiduals();
        Arrays.sort(res);
        ResidualHyperPlane hplane = toBeAdjusted.getResidualHyperPlane();
        int n = res.length;
        try {
            int i = 0;
            while (i < n) {
                ((ResidualContainer)res[i]).signedResidual += hplane.getParameter().get(0);
                ++i;
            }
        }
        catch (Exception e) {
            throw new Error("bla");
        }
        int k = n / 2 + 1;
        double minSumSq = 0.0;
        double assoziatedMean = 0.0;
        double lastMinSumSq = 0.0;
        double lastAssoziatedMean = 0.0;
        int i = 0;
        while (i < res.length - k + 1) {
            if (i == 0) {
                int j = 0;
                while (j < k) {
                    assoziatedMean += ((ResidualContainer)res[j]).signedResidual;
                    ++j;
                }
                assoziatedMean /= (double)k;
                j = 0;
                while (j < k) {
                    minSumSq += (((ResidualContainer)res[j]).signedResidual - assoziatedMean) * (((ResidualContainer)res[j]).signedResidual - assoziatedMean);
                    ++j;
                }
                lastAssoziatedMean = assoziatedMean;
                lastMinSumSq = minSumSq;
            } else {
                double nextMean = ((double)k * lastAssoziatedMean - ((ResidualContainer)res[i - 1]).signedResidual + ((ResidualContainer)res[i + k - 1]).signedResidual) / (double)k;
                double nextSumSq = lastMinSumSq - ((ResidualContainer)res[i - 1]).signedResidual * ((ResidualContainer)res[i - 1]).signedResidual + ((ResidualContainer)res[i + k - 1]).signedResidual * ((ResidualContainer)res[i + k - 1]).signedResidual - (double)k * nextMean * nextMean + (double)k * lastAssoziatedMean * lastAssoziatedMean;
                if (minSumSq > nextSumSq) {
                    minSumSq = nextSumSq;
                    assoziatedMean = nextMean;
                }
                lastAssoziatedMean = nextMean;
                lastMinSumSq = nextSumSq;
            }
            ++i;
        }
        try {
            hplane.getParameter().set(0, assoziatedMean);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PointSet.Point[] allPoints = ((PointSetGenotype)genotype).getPoints();
        hplane.updateResiduals((ResidualContainer[])res, allPoints);
    }

    public static void main(String[] args) {
        double[] res = new double[]{90.0, 93.0, 86.0, 92.0, 95.0, 83.0, 75.0, 40.0, 88.0, 80.0};
        Arrays.sort(res);
        int n = res.length;
        int k = n / 2 + 1;
        double minSumSq = 0.0;
        double assoziatedMean = 0.0;
        double lastMinSumSq = 0.0;
        double lastAssoziatedMean = 0.0;
        int i = 0;
        while (i < res.length - k + 1) {
            if (i == 0) {
                int j = 0;
                while (j < k) {
                    assoziatedMean += res[j];
                    ++j;
                }
                assoziatedMean /= (double)k;
                j = 0;
                while (j < k) {
                    minSumSq += (res[j] - assoziatedMean) * (res[j] - assoziatedMean);
                    ++j;
                }
                lastAssoziatedMean = assoziatedMean;
                lastMinSumSq = minSumSq;
            } else {
                double nextMean = ((double)k * lastAssoziatedMean - res[i - 1] + res[i + k - 1]) / (double)k;
                double nextSumSq = lastMinSumSq - res[i - 1] * res[i - 1] + res[i + k - 1] * res[i + k - 1] - (double)k * nextMean * nextMean + (double)k * lastAssoziatedMean * lastAssoziatedMean;
                if (minSumSq > nextSumSq) {
                    minSumSq = nextSumSq;
                    assoziatedMean = nextMean;
                }
                lastAssoziatedMean = nextMean;
                lastMinSumSq = nextSumSq;
            }
            ++i;
        }
        System.out.println(assoziatedMean);
    }
}

