/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.lassp.houle.RngPack;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import edu.cornell.lassp.houle.RngPack.RandomJava;
import edu.cornell.lassp.houle.RngPack.RandomSeedable;
import edu.cornell.lassp.houle.RngPack.Ranecu;
import edu.cornell.lassp.houle.RngPack.Ranlux;
import edu.cornell.lassp.houle.RngPack.Ranmar;

public class RandomApp {
    static String[] generators = new String[]{"ranmar", "ranecu", "ranlux", "randomjava", "null"};
    static String[] distributions = new String[]{"flat", "gaussian"};
    static int RANMAR = 0;
    static int RANECU = 1;
    static int RANLUX = 2;
    static int RANJAVA = 3;
    static int NULL = 4;
    static int FLAT = 0;
    static int GAUSSIAN = 1;

    static void die(String s) {
        System.err.println(s);
        System.exit(-1);
    }

    public static void main(String[] args) {
        boolean seeded = false;
        boolean gselected = false;
        boolean dselected = false;
        boolean noprint = false;
        boolean numbered = false;
        boolean luxuryset = false;
        int generator = RANMAR;
        int distribution = FLAT;
        long seed = RandomSeedable.ClockSeed();
        int luxury = 3;
        int n = 1;
        int i = 0;
        while (i < args.length) {
            block34: {
                String a = new String(args[i]);
                a.toLowerCase();
                if (a.compareTo("noprint") == 0) {
                    noprint = true;
                } else if (a.compareTo("seed") == 0) {
                    if (seeded) {
                        RandomApp.die("RandomApp: only one seed can be passed");
                    }
                    if (i == args.length - 1) {
                        RandomApp.die("RandomApp: missing seed.");
                    }
                    a = new String(args[++i]);
                    try {
                        seed = Long.parseLong(a);
                    }
                    catch (NumberFormatException ex) {
                        RandomApp.die("RandomApp: seed is not a valid number.");
                    }
                    seeded = true;
                } else if (a.compareTo("luxury") == 0) {
                    if (luxuryset) {
                        RandomApp.die("RandomApp: only one luxury level can be passed");
                    }
                    if (i == args.length - 1) {
                        RandomApp.die("RandomApp: missing luxury level.");
                    }
                    a = new String(args[++i]);
                    try {
                        luxury = Integer.parseInt(a);
                    }
                    catch (NumberFormatException ex) {
                        RandomApp.die("RandomApp: luxury level is not a valid number.");
                    }
                    luxuryset = true;
                    if (luxury < 0 || luxury > 4) {
                        RandomApp.die("RandomApp: luxury level must be between 0 and 4");
                    }
                } else {
                    int j = 0;
                    while (j < generators.length) {
                        if (a.compareTo(generators[j]) == 0) {
                            if (gselected) {
                                RandomApp.die("RandomApp: only one generator can be selected.");
                            }
                            generator = j;
                            gselected = true;
                            break block34;
                        }
                        ++j;
                    }
                    j = 0;
                    while (j < distributions.length) {
                        if (a.compareTo(distributions[j]) == 0) {
                            if (dselected) {
                                RandomApp.die("RandomApp: only one distribution can be selected.");
                            }
                            distribution = j;
                            dselected = true;
                            break block34;
                        }
                        ++j;
                    }
                    try {
                        n = Integer.parseInt(a);
                        if (numbered) {
                            RandomApp.die("RandomApp: only one number of random numbers can be selected.");
                        }
                        numbered = true;
                    }
                    catch (NumberFormatException ex) {
                        RandomApp.die("RandomApp: syntax error <" + a + ">");
                    }
                }
            }
            ++i;
        }
        RandomElement e = null;
        if (generator == RANMAR) {
            e = new Ranmar(seed);
        } else if (generator == RANECU) {
            e = new Ranecu(seed);
        } else if (generator == RANLUX) {
            e = new Ranlux(luxury, seed);
        } else if (generator == RANJAVA) {
            e = new RandomJava();
        }
        i = 1;
        while (i <= n) {
            double x = distribution == FLAT ? (generator != NULL ? e.raw() : 0.0) : (generator != NULL ? e.gaussian() : 0.0);
            if (!noprint) {
                System.out.println(x);
            }
            ++i;
        }
    }

    static double nullgen() {
        return 0.0;
    }
}

