% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_chrom.R
\name{read_chrom}
\alias{read_chrom}
\title{Read two-dimensional chromatogram}
\usage{
read_chrom(
  name,
  mod_time,
  sam_rate,
  per_eval = 0.1,
  x_cut = NULL,
  y_cut = NULL,
  verbose = TRUE
)
}
\arguments{
\item{name}{a name of the NetCDF file where the data is alocated.}

\item{mod_time}{a integer, the modulation time of the chromatographic run.}

\item{sam_rate}{a integer, the sampling rate of the equipment.
If sam_rate is missing, the sampling rate is calculated by the dividing 1 by
the difference of two adjacent scan time.}

\item{per_eval}{a double between 0 and 1, with the percentage of the run time
records to be evaluated if the sampling rate is homogeneous.}

\item{x_cut}{a vector with two elements representing the retention time range
to be mantained in the first dimension.}

\item{y_cut}{a vector with two elements representing the retention time range
to be mantained in the second dimension.}

\item{verbose}{a logical indicating if the information of chromatogram is
printted in the console.}
}
\description{
`read_GCxGC` returns a \emph{raw_GCxGC} with the sample name, the modulation
time, the chromatographic time range and the two-dimensional chromatogram.
}
\details{
This function reads the NetCDF file and retrieves values in the
\emph{total_intensity} array. Then, with the provided sampling rate and
modulation time, the chromatogram is folded into a numerical matrix,
representing the two-dimensional chromatogram. This function is an
adaptation of the presented routine by \insertCite{Skov2008;textual}{RGCxGC}.
}
\examples{
 
GB08_fl <- system.file("extdata", "08GB.cdf", package = "RGCxGC")
GB08 <- read_chrom(GB08_fl, 5L)

}
\references{
\insertAllCited{}
}
