% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LoadBeatVector.R
\name{LoadBeatVector}
\alias{LoadBeatVector}
\title{Loads beats positions from an R vector}
\usage{
LoadBeatVector(HRVData, beatPositions, scale = 1,
  datetime = "1/1/1900 0:0:0")
}
\arguments{
\item{HRVData}{Data structure that stores the beats recording and information 
related to it}

\item{beatPositions}{Numeric vector with the heartbeats occurrence's times since
the beginning of the recording. See \emph{scale} parameter to specify the 
units}

\item{scale}{Numeric value identifying the temporal units in which
the beat positions are specified: 1 if beat positions is specified in seconds, 
 0.001 if beat positions in milliseconds, etc.}

\item{datetime}{Date and time (DD/MM/YYYY HH:MM:SS) of the beginning of the
recording}
}
\value{
A \emph{HRVData} structure containing the heartbeat positions
from the \emph{beatPositions} vector.
}
\description{
Stores the beat positions from an R vector under the
\emph{HRVData} data structure.
}
\examples{
\dontrun{
hd = CreateHRVData()
hd = LoadBeatVector(hd, 
     c(0.000, 0.328, 0.715, 0.124, 1.50,1.880, 2.268, 2.656))
hd = BuildNIHR(hd)
# ... continue analyzing the recording
}
}

