/*
 * Decompiled with CFR 0.152.
 */
package com.nexr.rhive.hive.udf;

import com.nexr.rhive.hive.HiveVariations;
import com.nexr.rhive.util.RangeTreeFactory;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.Writable;

public class RangeKeyUDF
extends GenericUDF {
    private Configuration config;
    private ObjectInspector[] argumentOIs;
    private RANGEVALUE rangeValue;
    private ObjectInspector returnOI;
    private String breaks = null;
    private Boolean isRight = null;
    private static Map<String, RangeTreeFactory.RangeTree> TREES = new LinkedHashMap<String, RangeTreeFactory.RangeTree>();

    private RANGEVALUE valueOf(String typeName) throws IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException {
        if (typeName.equals(HiveVariations.getFieldValue(HiveVariations.serdeConstants, "INT_TYPE_NAME"))) {
            return RANGEVALUE.INT_TYPE;
        }
        if (typeName.equals(HiveVariations.getFieldValue(HiveVariations.serdeConstants, "BIGINT_TYPE_NAME"))) {
            return RANGEVALUE.BIGINT_TYPE;
        }
        if (typeName.equals(HiveVariations.getFieldValue(HiveVariations.serdeConstants, "DOUBLE_TYPE_NAME"))) {
            return RANGEVALUE.DOUBLE_TYPE;
        }
        if (typeName.equals(HiveVariations.getFieldValue(HiveVariations.serdeConstants, "FLOAT_TYPE_NAME"))) {
            return RANGEVALUE.FLOAT_TYPE;
        }
        if (typeName.equals(HiveVariations.getFieldValue(HiveVariations.serdeConstants, "STRING_TYPE_NAME"))) {
            return RANGEVALUE.STRING_TYPE;
        }
        throw new IllegalArgumentException("RHive doesn't support this type " + typeName);
    }

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (this.config == null) {
            SessionState session = SessionState.get();
            Object object = this.config = session == null ? new Configuration() : session.getConf();
        }
        if (arguments.length < 3) {
            throw new UDFArgumentLengthException("The function rkey(column, breaks, right) needs at least three arguments.");
        }
        String valueType = arguments[0].getTypeName();
        this.argumentOIs = arguments;
        try {
            this.rangeValue = this.valueOf(valueType);
        }
        catch (Exception e) {
            throw new UDFArgumentException((Throwable)e);
        }
        this.returnOI = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        return this.returnOI;
    }

    public Object evaluate(GenericUDF.DeferredObject[] records) throws HiveException {
        RangeTreeFactory.RangeTree tree;
        if (this.breaks == null) {
            this.breaks = (String)((PrimitiveObjectInspector)this.argumentOIs[1]).getPrimitiveJavaObject(records[1].get());
            this.isRight = new Boolean((String)((PrimitiveObjectInspector)this.argumentOIs[1]).getPrimitiveJavaObject(records[2].get()));
        }
        if ((tree = TREES.get(this.breaks)) == null) {
            tree = this.loadTree();
            TREES.put(this.breaks, tree);
        }
        Object value = ((PrimitiveObjectInspector)this.argumentOIs[0]).getPrimitiveJavaObject(records[0].get());
        try {
            return this.rangeValue.searchWritable(tree, value);
        }
        catch (NullPointerException e) {
            return null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("fail to eval : " + e.getMessage(), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RangeTreeFactory.RangeTree loadTree() {
        RangeTreeFactory.RangeTree tree = this.rangeValue.newTree(this.breaks, this.isRight, this.isRight == false);
        if (this.breaks.indexOf(":") > 0) {
            StringTokenizer st = new StringTokenizer(this.breaks, ":");
            if (st.countTokens() == 2) {
                String start = st.nextToken();
                String end = st.nextToken();
                String step = "1";
                return this.rangeValue.init(start, end, step, tree, this.isRight);
            }
            if (st.countTokens() != 3) throw new RuntimeException("fail to parse break syntax : " + this.breaks);
            String start = st.nextToken();
            String end = st.nextToken();
            String step = st.nextToken();
            return this.rangeValue.init(start, end, step, tree, this.isRight);
        }
        if (this.breaks.indexOf(",") <= 0) throw new RuntimeException("fail to parse break syntax : " + this.breaks);
        StringTokenizer st = new StringTokenizer(this.breaks, ",");
        String[] elements = new String[st.countTokens()];
        int i = 0;
        while (i < elements.length) {
            elements[i] = st.nextToken();
            ++i;
        }
        return this.rangeValue.init(elements, tree, this.isRight);
    }

    public String getDisplayString(String[] children) {
        StringBuilder sb = new StringBuilder();
        sb.append("rkey (");
        for (int i = 0; i < children.length - 1; ++i) {
            sb.append(children[i]).append(", ");
        }
        sb.append(children[children.length - 1]).append(")");
        return sb.toString();
    }

    public static enum RANGEVALUE {
        INT_TYPE{

            @Override
            ObjectInspector inspector() {
                return PrimitiveObjectInspectorFactory.writableIntObjectInspector;
            }

            @Override
            Object search(RangeTreeFactory.RangeTree tree, Object value) {
                return ((RangeTreeFactory.DoubleRangeTree)tree).search(((Integer)value).doubleValue());
            }

            @Override
            Writable searchWritable(RangeTreeFactory.RangeTree tree, Object value) {
                return ((RangeTreeFactory.DoubleRangeTree)tree).searchWritable(((Integer)value).doubleValue());
            }
        }
        ,
        BIGINT_TYPE{

            @Override
            ObjectInspector inspector() {
                return PrimitiveObjectInspectorFactory.writableLongObjectInspector;
            }

            @Override
            Object search(RangeTreeFactory.RangeTree tree, Object value) {
                return ((RangeTreeFactory.DoubleRangeTree)tree).search(((Long)value).doubleValue());
            }

            @Override
            Writable searchWritable(RangeTreeFactory.RangeTree tree, Object value) {
                return ((RangeTreeFactory.DoubleRangeTree)tree).searchWritable(((Long)value).doubleValue());
            }
        }
        ,
        DOUBLE_TYPE{

            @Override
            ObjectInspector inspector() {
                return PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
            }

            @Override
            Object search(RangeTreeFactory.RangeTree tree, Object value) {
                return ((RangeTreeFactory.DoubleRangeTree)tree).search((Double)value);
            }

            @Override
            Writable searchWritable(RangeTreeFactory.RangeTree tree, Object value) {
                return ((RangeTreeFactory.DoubleRangeTree)tree).searchWritable((Double)value);
            }
        }
        ,
        FLOAT_TYPE{

            @Override
            ObjectInspector inspector() {
                return PrimitiveObjectInspectorFactory.writableFloatObjectInspector;
            }

            @Override
            Object search(RangeTreeFactory.RangeTree tree, Object value) {
                return ((RangeTreeFactory.DoubleRangeTree)tree).search(((Float)value).doubleValue());
            }

            @Override
            Writable searchWritable(RangeTreeFactory.RangeTree tree, Object value) {
                return ((RangeTreeFactory.DoubleRangeTree)tree).searchWritable(((Float)value).doubleValue());
            }
        }
        ,
        STRING_TYPE{

            @Override
            ObjectInspector inspector() {
                return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
            }

            @Override
            RangeTreeFactory.RangeTree newTree(String name, boolean minExclusive, boolean maxExclusive) {
                return RangeTreeFactory.createStringTree(name, minExclusive, maxExclusive, null);
            }

            @Override
            RangeTreeFactory.RangeTree newTree(String name, boolean minExclusive, boolean maxExclusive, Object defaultValue) {
                return RangeTreeFactory.createStringTree(name, minExclusive, maxExclusive, defaultValue);
            }

            @Override
            Object asArray(String minValue, String maxValue) {
                return new String[]{minValue, maxValue};
            }

            @Override
            Object search(RangeTreeFactory.RangeTree tree, Object value) {
                return ((RangeTreeFactory.StringRangeTree)tree).search(String.valueOf(value));
            }

            @Override
            RangeTreeFactory.RangeTree init(String minValue, String maxValue, String stepValue, RangeTreeFactory.RangeTree tree, boolean minExclusive) {
                throw new RuntimeException("can't split min-max for string type.");
            }

            @Override
            RangeTreeFactory.RangeTree init(String[] breaks, RangeTreeFactory.RangeTree tree, boolean minExclusive) {
                throw new RuntimeException("can't split min-max for string type.");
            }

            @Override
            Writable searchWritable(RangeTreeFactory.RangeTree tree, Object value) {
                return ((RangeTreeFactory.StringRangeTree)tree).searchWritable(String.valueOf(value));
            }
        };


        abstract ObjectInspector inspector();

        RangeTreeFactory.RangeTree init(String minValue, String maxValue, String stepValue, RangeTreeFactory.RangeTree tree, boolean minExclusive) {
            String left = "(";
            String right = "]";
            if (!minExclusive) {
                left = "[";
                right = ")";
            }
            double lstart = this.parse(minValue);
            double lend = this.parse(maxValue);
            double step = this.parse(stepValue);
            for (double idx = lstart; idx < lend; idx += step) {
                double[] irange = new double[]{idx, idx + step};
                tree.put(irange, left + String.format("%f", irange[0]) + "," + String.format("%f", irange[1]) + right);
            }
            return tree;
        }

        RangeTreeFactory.RangeTree init(String[] breaks, RangeTreeFactory.RangeTree tree, boolean minExclusive) {
            String left = "(";
            String right = "]";
            if (!minExclusive) {
                left = "[";
                right = ")";
            }
            for (int i = 1; i < breaks.length; ++i) {
                double lstart = this.parse(breaks[i - 1]);
                double lend = this.parse(breaks[i]);
                double[] irange = new double[]{lstart, lend};
                tree.put(irange, left + breaks[i - 1] + "," + breaks[i] + right);
            }
            return tree;
        }

        RangeTreeFactory.RangeTree newTree(String name, boolean minExclusive, boolean maxExclusive) {
            return RangeTreeFactory.createDoubleTree(name, minExclusive, maxExclusive, null);
        }

        RangeTreeFactory.RangeTree newTree(String name, boolean minExclusive, boolean maxExclusive, Object defaultValue) {
            return RangeTreeFactory.createDoubleTree(name, minExclusive, maxExclusive, defaultValue);
        }

        Double parse(String value) {
            return Double.valueOf(value);
        }

        Object asArray(String minValue, String maxValue) {
            return new double[]{this.parse(minValue), this.parse(maxValue)};
        }

        abstract Object search(RangeTreeFactory.RangeTree var1, Object var2);

        abstract Writable searchWritable(RangeTreeFactory.RangeTree var1, Object var2);
    }
}

