\name{predict.flexsurv}
\alias{predict.flexsurv}

\title{
Prediction from an Flexible Parametric Model
}
\description{
Predict the survival of new observations based on an flexible parametric model from an object of the class \code{flexsurv}.
}

\usage{
\method{predict}{flexsurv}(object, ..., newdata, newtimes)
}

\arguments{
  \item{object}{An object returned by the function \code{aft.ggamma}, \code{aft.gamma}, \code{aft.weibull}, \code{ph.exp}, or \code{ph.gompertz}.}
    \item{...}{Further arguments passed.}
  \item{newdata}{An optional data frame containing covariate values at which to produce predicted values. There must be a column for every covariate included in \code{cov.quanti} and \code{cov.quali} included in the training sample. The default value is\code{NULL}, the predicted values are computed for the subjects of the training sample.}
  \item{newtimes}{The times at which to produce predicted values. The default value is\code{NULL}, the predicted values are computed for the observed times in the training data frame.}
}

\value{
\item{times}{A vector of numeric values with the times of the \code{predictions}.}
\item{predictions}{A matrix with the predictions of survivals of each subject (lines) for each observed times (columns).}
}


\details{
The model \code{object} is obtained from the \code{flexsurvreg} package.
}

\author{
Yohann Foucher <Yohann.Foucher@univ-poitiers.fr>

Camille Sabathe <camille.sabathe@univ-nantes.fr>
}

\examples{

data(dataDIVAT2)

# The estimation of the model from the first 200 lignes
model<-ph.gompertz(times="times", failures="failures", data=dataDIVAT2[1:200,],
  cov.quanti=c("age"),  cov.quali=c("hla", "retransplant", "ecd"))

# Predicted survival for 2 new subjects
pred <- predict(model,
  newdata=data.frame(age=c(52,52), hla=c(0,1), retransplant=c(1,1), ecd=c(0,1)))

plot(y=pred$predictions[1,], x=pred$times, xlab="Time (years)", ylab="Predicted survival",
     col=1, type="l", lty=1, lwd=2, ylim=c(0,1))

lines(y=pred$predictions[2,], x=pred$times, col=2, type="l", lty=1, lwd=2)

legend("bottomright", col=c(1,2), lty=1, lwd=2, c("Subject #1", "Subject #2"))
}

\keyword{Predicting}