% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotBarplot}
\alias{plotBarplot}
\title{Plot method for generating a barplot out of the benchmark results}
\usage{
plotBarplot(
  benchmarkRes,
  perDistType = FALSE,
  colList,
  nameList = NULL,
  withLabels = FALSE,
  withHorizLines = FALSE,
  title = NULL,
  xlim = NULL,
  xlab = "Mean of Absolute Z-Score Deviations",
  outputDir = NULL,
  filename = NULL,
  ...
)
}
\arguments{
\item{benchmarkRes}{(data frame) containing the overall benchmark results}

\item{perDistType}{(logical) indicating if one overall plot should be generated or if it should be separated by the distribution type}

\item{colList}{(character) vector specifying the colors used for the different algorithms (should correspond to columns of benchmark results)}

\item{nameList}{(character) vector specifying the names used in the legend (should correspond to columns of benchmark results), if NULL, colnames will be used}

\item{withLabels}{(logical) indicating whether the corresponding values should be plotted as well (default: FALSE)}

\item{withHorizLines}{(logical) indicating whether horizontal lines should be plotted for a better visual separation of the different categories (default:FALSE)}

\item{title}{(character) specifying plot title}

\item{xlim}{(numeric) vector specifying the limits in x-direction}

\item{xlab}{(character) specifying the x-axis label}

\item{outputDir}{(character) specifying a output directory}

\item{filename}{(character) specifying a filename for the plot}

\item{...}{additional arguments passed forward to other functions}
}
\value{
No return value. Instead, a plot is generated.
}
\description{
Plot method for generating a barplot out of the benchmark results
}
\author{
Tatjana Ammer \email{tatjana.ammer@roche.com}
}
