/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Undo;
import ij.WindowManager;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.gui.YesNoCancelDialog;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import java.awt.AWTEvent;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Label;
import java.awt.Rectangle;

public class RGBStackConverter
implements PlugIn,
DialogListener {
    int channels1;
    int slices1;
    int frames1;
    int slices2;
    int frames2;
    int width;
    int height;
    double imageSize;
    static boolean keep = true;

    public void run(String arg) {
        ImagePlus imp = IJ.getImage();
        CompositeImage cimg = imp.isComposite() ? (CompositeImage)imp : null;
        int size = imp.getStackSize();
        if ((size < 2 || size > 3) && cimg == null) {
            IJ.error("A 2 or 3 image stack, or a HyperStack, required");
            return;
        }
        int type = imp.getType();
        if (cimg == null && type != 0 && type != 1) {
            IJ.error("8-bit or 16-bit grayscale stack required");
            return;
        }
        if (!imp.lock()) {
            return;
        }
        Undo.reset();
        String title = imp.getTitle() + " (RGB)";
        if (cimg != null) {
            this.compositeToRGB(cimg, title);
        } else if (type == 1) {
            this.sixteenBitsToRGB(imp);
        } else {
            ImagePlus imp2 = imp.createImagePlus();
            imp2.setStack(title, imp.getStack());
            ImageConverter ic = new ImageConverter(imp2);
            ic.convertRGBStackToRGB();
            imp2.show();
        }
        imp.unlock();
    }

    void compositeToRGB(CompositeImage imp, String title) {
        int frames;
        int slices;
        int images;
        int channels = imp.getNChannels();
        if (channels == (images = channels * (slices = imp.getNSlices()) * (frames = imp.getNFrames()))) {
            this.compositeImageToRGB(imp, title);
            return;
        }
        this.width = imp.getWidth();
        this.height = imp.getHeight();
        this.imageSize = (double)(this.width * this.height) * 4.0 / 1048576.0;
        this.channels1 = imp.getNChannels();
        this.slices1 = this.slices2 = imp.getNSlices();
        this.frames1 = this.frames2 = imp.getNFrames();
        int c1 = imp.getChannel();
        int z1 = imp.getSlice();
        int t2 = imp.getFrame();
        if (!this.showDialog()) {
            return;
        }
        String title2 = keep ? WindowManager.getUniqueName(imp.getTitle()) : imp.getTitle();
        ImagePlus imp2 = imp.createHyperStack(title2, 1, this.slices2, this.frames2, 24);
        this.convertHyperstack(imp, imp2);
        imp2.setOpenAsHyperStack(this.slices2 > 1 || this.frames2 > 1);
        imp2.show();
        if (!keep) {
            imp.changes = false;
            imp.close();
        }
    }

    public void convertHyperstack(ImagePlus imp, ImagePlus imp2) {
        int slices = imp2.getNSlices();
        int frames = imp2.getNFrames();
        int c1 = imp.getChannel();
        int z1 = imp.getSlice();
        int t1 = imp.getFrame();
        boolean i = true;
        int c = 1;
        ImageStack stack = imp.getStack();
        ImageStack stack2 = imp2.getStack();
        imp.setPositionWithoutUpdate(c, 1, 1);
        ImageProcessor ip = imp.getProcessor();
        double min = ip.getMin();
        double max = ip.getMax();
        for (int z = 1; z <= slices; ++z) {
            if (slices == 1) {
                z = z1;
            }
            for (int t = 1; t <= frames; ++t) {
                if (frames == 1) {
                    t = t1;
                }
                imp.setPositionWithoutUpdate(c, z, t);
                Image img = imp.getImage();
                int n2 = imp2.getStackIndex(c, z, t);
                stack2.setPixels(new ColorProcessor(img).getPixels(), n2);
            }
        }
        imp.setPosition(c1, z1, t1);
        imp2.resetStack();
        imp2.setPosition(1, 1, 1);
    }

    void compositeToRGB2(CompositeImage imp, String title) {
        int n;
        int frames;
        int slices;
        int images;
        int channels = imp.getNChannels();
        if (channels == (images = channels * (slices = imp.getNSlices()) * (frames = imp.getNFrames()))) {
            this.compositeImageToRGB(imp, title);
            return;
        }
        String msg = null;
        msg = frames > 1 ? "Convert all " + frames + " frames?" : "Convert all " + slices + " slices?";
        if (!IJ.isMacro()) {
            YesNoCancelDialog d = new YesNoCancelDialog((Frame)IJ.getInstance(), "Convert to RGB", msg);
            if (d.cancelPressed()) {
                return;
            }
            if (!d.yesPressed()) {
                this.compositeImageToRGB(imp, title);
                return;
            }
        }
        if ((n = frames) == 1) {
            n = slices;
        }
        ImageStack stack = new ImageStack(imp.getWidth(), imp.getHeight());
        int c = imp.getChannel();
        int z = imp.getSlice();
        int t = imp.getFrame();
        for (int i = 1; i <= n; ++i) {
            if (frames == 1) {
                imp.setPositionWithoutUpdate(imp.getChannel(), i, imp.getFrame());
            } else {
                imp.setPositionWithoutUpdate(imp.getChannel(), imp.getSlice(), i);
            }
            stack.addSlice(null, new ColorProcessor(imp.getImage()));
        }
        imp.setPosition(c, z, t);
        ImagePlus imp2 = imp.createImagePlus();
        imp2.setStack(title, stack);
        Object info = imp.getProperty("Info");
        if (info != null) {
            imp2.setProperty("Info", info);
        }
        imp2.show();
    }

    void compositeImageToRGB(CompositeImage imp, String title) {
        if (imp.getMode() == 1) {
            ImagePlus imp2 = imp.createImagePlus();
            imp.updateImage();
            imp2.setProcessor(title, new ColorProcessor(imp.getImage()));
            imp2.show();
            return;
        }
        ImageStack stack = new ImageStack(imp.getWidth(), imp.getHeight());
        int c = imp.getChannel();
        int n = imp.getNChannels();
        for (int i = 1; i <= n; ++i) {
            imp.setPositionWithoutUpdate(i, 1, 1);
            stack.addSlice(null, new ColorProcessor(imp.getImage()));
        }
        imp.setPosition(c, 1, 1);
        ImagePlus imp2 = imp.createImagePlus();
        imp2.setStack(title, stack);
        Object info = imp.getProperty("Info");
        if (info != null) {
            imp2.setProperty("Info", info);
        }
        imp2.show();
    }

    void sixteenBitsToRGB(ImagePlus imp) {
        Rectangle r;
        Roi roi = imp.getRoi();
        if (roi != null) {
            r = roi.getBounds();
            int width = r.width;
            int height = r.height;
        } else {
            r = new Rectangle(0, 0, imp.getWidth(), imp.getHeight());
        }
        ImageStack stack1 = imp.getStack();
        ImageStack stack2 = new ImageStack(r.width, r.height);
        for (int i = 1; i <= stack1.getSize(); ++i) {
            ImageProcessor ip = stack1.getProcessor(i);
            ip.setRoi(r);
            ImageProcessor ip2 = ip.crop();
            ip2 = ip2.convertToByte(true);
            stack2.addSlice(null, ip2);
        }
        ImagePlus imp2 = imp.createImagePlus();
        imp2.setStack(imp.getTitle() + " (RGB)", stack2);
        ImageConverter ic = new ImageConverter(imp2);
        ic.convertRGBStackToRGB();
        imp2.show();
    }

    boolean showDialog() {
        GenericDialog gd = new GenericDialog("Convert to RGB");
        gd.setInsets(10, 20, 5);
        gd.addMessage("Create RGB Image With:");
        gd.setInsets(0, 35, 0);
        if (this.slices1 != 1) {
            gd.addCheckbox("Slices (" + this.slices1 + ")", true);
        }
        gd.setInsets(0, 35, 0);
        if (this.frames1 != 1) {
            gd.addCheckbox("Frames (" + this.frames1 + ")", true);
        }
        gd.setInsets(5, 20, 0);
        gd.addMessage(this.getNewDimensions() + "      ");
        gd.setInsets(15, 20, 0);
        gd.addCheckbox("Keep Source", keep);
        gd.addDialogListener(this);
        gd.showDialog();
        return !gd.wasCanceled();
    }

    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        if (IJ.isMacOSX()) {
            IJ.wait(100);
        }
        if (this.slices1 != 1) {
            int n = this.slices2 = gd.getNextBoolean() ? this.slices1 : 1;
        }
        if (this.frames1 != 1) {
            this.frames2 = gd.getNextBoolean() ? this.frames1 : 1;
        }
        keep = gd.getNextBoolean();
        ((Label)gd.getMessage()).setText(this.getNewDimensions());
        return true;
    }

    String getNewDimensions() {
        String s1 = this.slices2 > 1 ? "x" + this.slices2 : "";
        String s2 = this.frames2 > 1 ? "x" + this.frames2 : "";
        String s = this.width + "x" + this.height + s1 + s2;
        s = s + " (" + (int)Math.round(this.imageSize * (double)this.slices2 * (double)this.frames2) + "MB)";
        return s;
    }
}

