/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.ImageWindow;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.plugin.ImagesToStack;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import ij.process.LUT;

public class StackEditor
implements PlugIn {
    ImagePlus imp;
    int nSlices;
    int width;
    int height;

    public void run(String arg) {
        this.imp = IJ.getImage();
        this.nSlices = this.imp.getStackSize();
        this.width = this.imp.getWidth();
        this.height = this.imp.getHeight();
        if (arg.equals("add")) {
            this.addSlice();
        } else if (arg.equals("delete")) {
            this.deleteSlice();
        } else if (arg.equals("toimages")) {
            this.convertStackToImages(this.imp);
        }
    }

    void addSlice() {
        if (this.imp.isDisplayedHyperStack()) {
            return;
        }
        if (!this.imp.lock()) {
            return;
        }
        int id = 0;
        ImageStack stack = this.imp.getStack();
        if (stack.getSize() == 1) {
            Object obj;
            String label = stack.getSliceLabel(1);
            if (label != null && label.indexOf("\n") != -1) {
                stack.setSliceLabel(null, 1);
            }
            if ((obj = this.imp.getProperty("Label")) != null && obj instanceof String) {
                stack.setSliceLabel((String)obj, 1);
            }
            id = this.imp.getID();
        }
        ImageProcessor ip = this.imp.getProcessor();
        int n = this.imp.getCurrentSlice();
        if (IJ.altKeyDown()) {
            --n;
        }
        stack.addSlice(null, ip.createProcessor(this.width, this.height), n);
        this.imp.setStack(null, stack);
        this.imp.setSlice(n + 1);
        this.imp.unlock();
        if (id != 0) {
            IJ.selectWindow(id);
        }
    }

    void deleteSlice() {
        String label;
        if (this.imp.isDisplayedHyperStack()) {
            return;
        }
        if (this.nSlices < 2) {
            IJ.error("\"Delete Slice\" requires a stack");
            return;
        }
        if (!this.imp.lock()) {
            return;
        }
        ImageStack stack = this.imp.getStack();
        int n = this.imp.getCurrentSlice();
        stack.deleteSlice(n);
        if (stack.getSize() == 1 && (label = stack.getSliceLabel(1)) != null) {
            this.imp.setProperty("Label", label);
        }
        this.imp.setStack(null, stack);
        if (n-- < 1) {
            n = 1;
        }
        this.imp.setSlice(n);
        this.imp.unlock();
    }

    public void convertImagesToStack() {
        new ImagesToStack().run("");
    }

    public void convertStackToImages(ImagePlus imp) {
        CompositeImage cimg;
        boolean ok;
        if (this.nSlices < 2) {
            IJ.error("\"Convert Stack to Images\" requires a stack");
            return;
        }
        if (!imp.lock()) {
            return;
        }
        ImageStack stack = imp.getStack();
        int size = stack.getSize();
        if (size > 30 && !IJ.isMacro() && !(ok = IJ.showMessageWithCancel("Convert to Images?", "Are you sure you want to convert this\nstack to " + size + " separate windows?"))) {
            imp.unlock();
            return;
        }
        Calibration cal = imp.getCalibration();
        CompositeImage compositeImage = cimg = imp.isComposite() ? (CompositeImage)imp : null;
        if (imp.getNChannels() != imp.getStackSize()) {
            cimg = null;
        }
        for (int i = 1; i <= size; ++i) {
            LUT lut;
            String label = stack.getShortSliceLabel(i);
            String title = label != null && !label.equals("") ? label : this.getTitle(imp, i);
            ImageProcessor ip = stack.getProcessor(i);
            if (cimg != null && (lut = cimg.getChannelLut(i)) != null) {
                ip.setColorModel(lut);
                ip.setMinAndMax(lut.min, lut.max);
            }
            ImagePlus imp2 = new ImagePlus(title, ip);
            imp2.setCalibration(cal);
            String info = stack.getSliceLabel(i);
            if (info != null && !info.equals(label)) {
                imp2.setProperty("Info", info);
            }
            imp2.show();
        }
        imp.changes = false;
        ImageWindow win = imp.getWindow();
        if (win != null) {
            win.close();
        } else if (Interpreter.isBatchMode()) {
            Interpreter.removeBatchModeImage(imp);
        }
        imp.unlock();
    }

    String getTitle(ImagePlus imp, int n) {
        String digits = "00000000" + n;
        return imp.getShortTitle() + "-" + digits.substring(digits.length() - 4, digits.length());
    }
}

