/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.ImageJ;
import ij.Macro;
import ij.Prefs;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.macro.Interpreter;
import ij.plugin.frame.Recorder;
import ij.util.Java2;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class SaveDialog {
    private String dir;
    private String name;
    private String title;
    private String ext;

    public SaveDialog(String string, String string2, String string3) {
        this.title = string;
        this.ext = string3;
        if (this.isMacro()) {
            return;
        }
        String string4 = OpenDialog.getDefaultDirectory();
        string2 = SaveDialog.setExtension(string2, string3);
        if (Prefs.useJFileChooser) {
            this.jSave(string, string4, string2);
        } else {
            this.save(string, string4, string2);
        }
        if (this.name != null && this.dir != null) {
            OpenDialog.setDefaultDirectory(this.dir);
        }
        IJ.showStatus(string + ": " + this.dir + this.name);
    }

    public SaveDialog(String string, String string2, String string3, String string4) {
        this.title = string;
        this.ext = string4;
        if (this.isMacro()) {
            return;
        }
        string3 = SaveDialog.setExtension(string3, string4);
        if (Prefs.useJFileChooser) {
            this.jSave(string, string2, string3);
        } else {
            this.save(string, string2, string3);
        }
        IJ.showStatus(string + ": " + this.dir + this.name);
    }

    boolean isMacro() {
        String string = Macro.getOptions();
        if (string != null) {
            Object object;
            String string2 = Macro.getValue(string, this.title, null);
            if (string2 == null) {
                string2 = Macro.getValue(string, "path", null);
            }
            if (string2 != null && string2.indexOf(".") == -1 && !new File(string2).exists()) {
                String string3;
                if (string2.startsWith("&")) {
                    string2 = string2.substring(1);
                }
                String string4 = string3 = (object = Interpreter.getInstance()) != null ? ((Interpreter)object).getStringVariable(string2) : null;
                if (string3 != null) {
                    string2 = string3;
                }
            }
            if (string2 != null) {
                object = new Opener();
                this.dir = ((Opener)object).getDir(string2);
                this.name = ((Opener)object).getName(string2);
                return true;
            }
        }
        return false;
    }

    public static String setExtension(String string, String string2) {
        if (string == null || string2 == null || string2.length() == 0) {
            return string;
        }
        int n = string.lastIndexOf(".");
        string = n >= 0 && string.length() - n <= 5 ? (n + 1 < string.length() && Character.isDigit(string.charAt(n + 1)) ? string + string2 : string.substring(0, n) + string2) : string + string2;
        return string;
    }

    void jSave(String string, String string2, String string3) {
        Java2.setSystemLookAndFeel();
        if (EventQueue.isDispatchThread()) {
            this.jSaveDispatchThread(string, string2, string3);
        } else {
            this.jSaveInvokeAndWait(string, string2, string3);
        }
    }

    void jSaveDispatchThread(String string, String string2, String string3) {
        int n;
        int n2;
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(string);
        if (string2 != null && (file = new File(string2)) != null) {
            jFileChooser.setCurrentDirectory(file);
        }
        if (string3 != null) {
            jFileChooser.setSelectedFile(new File(string3));
        }
        if ((n2 = jFileChooser.showSaveDialog(IJ.getInstance())) != 0) {
            Macro.abort();
            return;
        }
        File file2 = jFileChooser.getSelectedFile();
        if (file2.exists() && (n = JOptionPane.showConfirmDialog(jFileChooser, "The file " + file2.getName() + " already exists. \nWould you like to replace it?", "Replace?", 0, 2)) != 0) {
            file2 = null;
        }
        if (file2 == null) {
            Macro.abort();
        } else {
            this.dir = jFileChooser.getCurrentDirectory().getPath() + File.separator;
            this.name = jFileChooser.getName(file2);
            if (this.name != null && this.name.indexOf(".") == -1) {
                this.name = SaveDialog.setExtension(this.name, this.ext);
            }
        }
    }

    void jSaveInvokeAndWait(final String string, final String string2, final String string3) {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    int n;
                    int n2;
                    File file;
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setDialogTitle(string);
                    if (string2 != null && (file = new File(string2)) != null) {
                        jFileChooser.setCurrentDirectory(file);
                    }
                    if (string3 != null) {
                        jFileChooser.setSelectedFile(new File(string3));
                    }
                    if ((n2 = jFileChooser.showSaveDialog(IJ.getInstance())) != 0) {
                        Macro.abort();
                        return;
                    }
                    File file2 = jFileChooser.getSelectedFile();
                    if (file2.exists() && (n = JOptionPane.showConfirmDialog(jFileChooser, "The file " + file2.getName() + " already exists. \nWould you like to replace it?", "Replace?", 0, 2)) != 0) {
                        file2 = null;
                    }
                    if (file2 == null) {
                        Macro.abort();
                    } else {
                        SaveDialog.this.dir = jFileChooser.getCurrentDirectory().getPath() + File.separator;
                        SaveDialog.this.name = jFileChooser.getName(file2);
                        if (SaveDialog.this.name != null && SaveDialog.this.name.indexOf(".") == -1) {
                            SaveDialog.this.name = SaveDialog.setExtension(SaveDialog.this.name, SaveDialog.this.ext);
                        }
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void save(String string, String string2, String string3) {
        ImageJ imageJ = IJ.getInstance();
        Frame frame = imageJ != null ? imageJ : new Frame();
        FileDialog fileDialog = new FileDialog(frame, string, 1);
        if (string3 != null) {
            fileDialog.setFile(string3);
        }
        if (string2 != null) {
            fileDialog.setDirectory(string2);
        }
        fileDialog.show();
        this.name = fileDialog.getFile();
        if (this.name != null && this.name.indexOf(".") == -1) {
            this.name = SaveDialog.setExtension(this.name, this.ext);
        }
        this.dir = fileDialog.getDirectory();
        if (this.name == null) {
            Macro.abort();
        }
        fileDialog.dispose();
        if (imageJ == null) {
            frame.dispose();
        }
    }

    public String getDirectory() {
        OpenDialog.setLastDirectory(this.dir);
        return this.dir;
    }

    public String getFileName() {
        if (Recorder.record) {
            Recorder.recordPath(this.title, this.dir + this.name);
        }
        OpenDialog.setLastName(this.name);
        return this.name;
    }
}

