/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.io.FileSaver;
import ij.plugin.PlugIn;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public class JpegWriter
implements PlugIn {
    public static final int DEFAULT_QUALITY = 75;

    public void run(String string) {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            return;
        }
        imagePlus.startTiming();
        this.saveAsJpeg(imagePlus, string, FileSaver.getJpegQuality());
        IJ.showTime(imagePlus, imagePlus.getStartTime(), "JpegWriter: ");
    }

    public static String save(ImagePlus imagePlus, String string, int n) {
        imagePlus.startTiming();
        String string2 = new JpegWriter().saveAsJpeg(imagePlus, string, n);
        IJ.showTime(imagePlus, imagePlus.getStartTime(), "JpegWriter: ");
        return string2;
    }

    String saveAsJpeg(ImagePlus imagePlus, String string, int n) {
        boolean bl;
        int n2 = imagePlus.getWidth();
        int n3 = imagePlus.getHeight();
        int n4 = 1;
        boolean bl2 = bl = imagePlus.getOverlay() != null && !imagePlus.getHideOverlay();
        if (imagePlus.getProcessor().isDefaultLut() && !imagePlus.isComposite() && !bl) {
            n4 = 10;
        }
        BufferedImage bufferedImage = new BufferedImage(n2, n3, n4);
        String string2 = null;
        try {
            Graphics2D graphics2D = bufferedImage.createGraphics();
            Image image = imagePlus.getImage();
            if (bl) {
                image = imagePlus.flatten().getImage();
            }
            graphics2D.drawImage(image, 0, 0, null);
            graphics2D.dispose();
            Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName("jpeg");
            ImageWriter imageWriter = iterator.next();
            ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(new File(string));
            imageWriter.setOutput(imageOutputStream);
            ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
            imageWriteParam.setCompressionMode(2);
            imageWriteParam.setCompressionQuality((float)n / 100.0f);
            if (n == 100) {
                imageWriteParam.setSourceSubsampling(1, 1, 0, 0);
            }
            IIOImage iIOImage = new IIOImage(bufferedImage, null, null);
            imageWriter.write(null, iIOImage, imageWriteParam);
            imageOutputStream.close();
            imageWriter.dispose();
        }
        catch (Exception exception) {
            string2 = "" + exception;
            IJ.error("Jpeg Writer", "" + string2);
        }
        return string2;
    }

    public static void setQuality(int n) {
        FileSaver.setJpegQuality(n);
    }

    public static int getQuality() {
        return FileSaver.getJpegQuality();
    }
}

