/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileInfo;
import ij.measure.Calibration;
import ij.plugin.HyperStackReducer;
import ij.plugin.filter.PlugInFilter;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;

public class RGBStackSplitter
implements PlugInFilter {
    ImagePlus imp;
    public ImageStack red;
    public ImageStack green;
    public ImageStack blue;

    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        if (imagePlus != null && imagePlus.isComposite()) {
            this.splitChannels(imagePlus);
            return 4096;
        }
        if (imagePlus != null && imagePlus.getBitDepth() != 24) {
            IJ.error("Split Channels", "Multichannel image required");
            return 4096;
        }
        return 272;
    }

    public void run(ImageProcessor imageProcessor) {
        this.split(this.imp);
    }

    public void split(ImagePlus imagePlus) {
        boolean bl = IJ.altKeyDown();
        String string = imagePlus.getTitle();
        Calibration calibration = imagePlus.getCalibration();
        FileInfo fileInfo = imagePlus.getOriginalFileInfo();
        this.split(imagePlus.getStack(), bl);
        if (!bl) {
            imagePlus.unlock();
            imagePlus.changes = false;
            imagePlus.close();
        }
        ImagePlus imagePlus2 = new ImagePlus(string + " (red)", this.red);
        imagePlus2.setCalibration(calibration);
        imagePlus2.setFileInfo(fileInfo);
        imagePlus2.show();
        if (IJ.isMacOSX()) {
            IJ.wait(500);
        }
        ImagePlus imagePlus3 = new ImagePlus(string + " (green)", this.green);
        imagePlus3.setCalibration(calibration);
        imagePlus2.setFileInfo(fileInfo);
        imagePlus3.show();
        if (IJ.isMacOSX()) {
            IJ.wait(500);
        }
        ImagePlus imagePlus4 = new ImagePlus(string + " (blue)", this.blue);
        imagePlus4.setCalibration(calibration);
        imagePlus4.setFileInfo(fileInfo);
        imagePlus4.show();
    }

    public void split(ImageStack imageStack, boolean bl) {
        int n = imageStack.getWidth();
        int n2 = imageStack.getHeight();
        this.red = new ImageStack(n, n2);
        this.green = new ImageStack(n, n2);
        this.blue = new ImageStack(n, n2);
        int n3 = 1;
        int n4 = bl ? 1 : 0;
        int n5 = imageStack.getSize();
        for (int i = 1; i <= n5; ++i) {
            IJ.showStatus(i + "/" + n5);
            byte[] byArray = new byte[n * n2];
            byte[] byArray2 = new byte[n * n2];
            byte[] byArray3 = new byte[n * n2];
            ColorProcessor colorProcessor = (ColorProcessor)imageStack.getProcessor(n3);
            n3 += n4;
            colorProcessor.getRGB(byArray, byArray2, byArray3);
            if (!bl) {
                imageStack.deleteSlice(1);
            }
            this.red.addSlice(null, byArray);
            this.green.addSlice(null, byArray2);
            this.blue.addSlice(null, byArray3);
            IJ.showProgress((double)i / (double)n5);
        }
    }

    public static ImagePlus[] splitChannelsToArray(ImagePlus imagePlus, boolean bl) {
        if (!imagePlus.isComposite()) {
            String string = "splitChannelsToArray was called on a non-composite image";
            IJ.error(string);
            return null;
        }
        int n = imagePlus.getWidth();
        int n2 = imagePlus.getHeight();
        int n3 = imagePlus.getNChannels();
        int n4 = imagePlus.getNSlices();
        int n5 = imagePlus.getNFrames();
        int n6 = imagePlus.getBitDepth();
        int n7 = n4 * n5;
        FileInfo fileInfo = imagePlus.getOriginalFileInfo();
        ImagePlus[] imagePlusArray = new ImagePlus[n3];
        HyperStackReducer hyperStackReducer = new HyperStackReducer(imagePlus);
        for (int i = 1; i <= n3; ++i) {
            ImageStack imageStack = new ImageStack(n, n2, n7);
            imageStack.setPixels(imagePlus.getProcessor().getPixels(), 1);
            ImagePlus imagePlus2 = new ImagePlus("C" + i + "-" + imagePlus.getTitle(), imageStack);
            imageStack.setPixels(null, 1);
            imagePlus.setPosition(i, 1, 1);
            imagePlus2.setDimensions(1, n4, n5);
            imagePlus2.setCalibration(imagePlus.getCalibration());
            hyperStackReducer.reduce(imagePlus2);
            if (imagePlus2.getNDimensions() > 3) {
                imagePlus2.setOpenAsHyperStack(true);
            }
            imagePlus2.setFileInfo(fileInfo);
            imagePlusArray[i - 1] = imagePlus2;
        }
        imagePlus.changes = false;
        if (bl) {
            imagePlus.close();
        }
        return imagePlusArray;
    }

    void splitChannels(ImagePlus imagePlus) {
        ImagePlus[] imagePlusArray = RGBStackSplitter.splitChannelsToArray(imagePlus, true);
        for (int i = 0; i < imagePlusArray.length; ++i) {
            imagePlusArray[i].show();
        }
    }
}

