/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.seats;

import ec.satoolkit.ComponentDescriptor;
import ec.satoolkit.DecompositionMode;
import ec.satoolkit.DefaultSeriesDecomposition;
import ec.satoolkit.ISaResults;
import ec.satoolkit.ISeriesDecomposition;
import ec.satoolkit.seats.SeatsModel;
import ec.tstoolkit.algorithm.ProcessingInformation;
import ec.tstoolkit.arima.ArimaModel;
import ec.tstoolkit.information.Information;
import ec.tstoolkit.information.InformationMapping;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.modelling.ComponentInformation;
import ec.tstoolkit.modelling.ComponentType;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.ucarima.UcarimaModel;
import ec.tstoolkit.ucarima.WienerKolmogorovDiagnostics;
import ec.tstoolkit.ucarima.WienerKolmogorovEstimators;
import ec.tstoolkit.utilities.Arrays2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class SeatsResults
implements ISaResults {
    public static final ComponentDescriptor SeasonallyAdjusted = new ComponentDescriptor("sa", 1, false, true);
    public static final ComponentDescriptor Trend = new ComponentDescriptor("trend", 0, true, true);
    public static final ComponentDescriptor Seasonal = new ComponentDescriptor("seasonal", 1, true, false);
    public static final ComponentDescriptor Transitory = new ComponentDescriptor("transitory", 2, true, false);
    public static final ComponentDescriptor Irregular = new ComponentDescriptor("irregular", 3, true, false);
    public static final List<ComponentDescriptor> descriptors = Arrays2.unmodifiableList(SeasonallyAdjusted, Trend, Seasonal, Transitory, Irregular);
    private static final ComponentDescriptor aIrregular = new ComponentDescriptor("irregular", 2, true, false);
    public static final List<ComponentDescriptor> airlineDescriptors = Arrays2.unmodifiableList(SeasonallyAdjusted, Trend, Seasonal, aIrregular);
    private WienerKolmogorovEstimators wk_;
    SeatsModel model;
    UcarimaModel decomposition;
    DefaultSeriesDecomposition initialComponents;
    DefaultSeriesDecomposition finalComponents;
    InformationSet info_;
    private List<ProcessingInformation> log_ = new ArrayList<ProcessingInformation>();
    private WienerKolmogorovDiagnostics diagnostics;
    private static final InformationMapping<SeatsResults> MAPPING = new InformationMapping<SeatsResults>(SeatsResults.class);
    public static final String CUTOFF = "parameters_cutoff";
    public static final String CHANGED = "model_changed";
    public static final String SEAS = "seasonality";
    public static final String AR_ROOT = "ar_root";
    public static final String MA_ROOT = "ma_root";
    public static final String TVAR_ESTIMATE = "tvar-estimate";
    public static final String TVAR_ESTIMATOR = "tvar-estimator";
    public static final String TVAR_PVALUE = "tvar-pvalue";
    public static final String SAVAR_ESTIMATE = "savar-estimate";
    public static final String SAVAR_ESTIMATOR = "savar-estimator";
    public static final String SAVAR_PVALUE = "savar-pvalue";
    public static final String SVAR_ESTIMATE = "svar-estimate";
    public static final String SVAR_ESTIMATOR = "svar-estimator";
    public static final String SVAR_PVALUE = "svar-pvalue";
    public static final String IVAR_ESTIMATE = "ivar-estimate";
    public static final String IVAR_ESTIMATOR = "ivar-estimator";
    public static final String IVAR_PVALUE = "ivar-pvalue";
    public static final String SAAC1_ESTIMATE = "saac1-estimate";
    public static final String SAAC1_ESTIMATOR = "saac1-estimator";
    public static final String SAAC1_PVALUE = "saac1-pvalue";
    public static final String IAC1_ESTIMATE = "iac1-estimate";
    public static final String IAC1_ESTIMATOR = "iac1-estimator";
    public static final String IAC1_PVALUE = "iac1-pvalue";
    public static final String TICORR_ESTIMATE = "ticorr-estimate";
    public static final String TICORR_ESTIMATOR = "ticorr-estimator";
    public static final String TICORR_PVALUE = "ticorr-pvalue";
    public static final String SICORR_ESTIMATE = "sicorr-estimate";
    public static final String SICORR_ESTIMATOR = "sicorr-estimator";
    public static final String SICORR_PVALUE = "sicorr-pvalue";
    public static final String TSCORR_ESTIMATE = "tscorr-estimate";
    public static final String TSCORR_ESTIMATOR = "tscorr-estimator";
    public static final String TSCORR_PVALUE = "tscorr-pvalue";
    private static final int T_CMP = 0;
    private static final int SA_CMP = 1;
    private static final int I_CMP = 3;
    private static final int S_CMP = 2;

    public static String[] getComponentsName(UcarimaModel ucm) {
        List<ComponentDescriptor> d = ucm.getComponentsCount() == 4 ? descriptors : airlineDescriptors;
        String[] names = new String[d.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = d.get((int)i).name;
        }
        return names;
    }

    public static ArimaModel[] getComponents(UcarimaModel ucm) {
        List<ComponentDescriptor> d = ucm.getComponentsCount() == 4 ? descriptors : airlineDescriptors;
        ArimaModel[] cmps = new ArimaModel[d.size()];
        for (int i = 0; i < cmps.length; ++i) {
            cmps[i] = d.get((int)i).signal ? ucm.getComponent(d.get((int)i).cmp) : ucm.getComplement(d.get((int)i).cmp);
        }
        return cmps;
    }

    void addProcessingInformation(ProcessingInformation info) {
        this.log_.add(info);
    }

    void addProcessingInformation(Collection<ProcessingInformation> info) {
        if (this.log_ != null && info != null) {
            this.log_.addAll(info);
        }
    }

    public WienerKolmogorovDiagnostics diagnostics() {
        if (this.diagnostics == null) {
            try {
                UcarimaModel ucm = this.decomposition.clone();
                if (ucm.getComponentsCount() > 3) {
                    ucm.compact(2, 2);
                }
                int[] cmps = new int[]{1, -2, 2, 3};
                double err = this.model.getSer();
                TsData t = this.initialComponents.getSeries(ComponentType.Trend, ComponentInformation.Value);
                TsData s = this.initialComponents.getSeries(ComponentType.Seasonal, ComponentInformation.Value);
                TsData i = this.initialComponents.getSeries(ComponentType.Irregular, ComponentInformation.Value);
                TsData sa = this.initialComponents.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.Value);
                double[][] data = new double[][]{t == null ? null : t.internalStorage(), s == null ? null : sa.internalStorage(), s == null ? null : s.internalStorage(), i == null ? null : i.internalStorage()};
                this.diagnostics = WienerKolmogorovDiagnostics.make(ucm, err, data, cmps);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.diagnostics;
    }

    @Override
    public DefaultSeriesDecomposition getSeriesDecomposition() {
        return this.finalComponents;
    }

    @Override
    public InformationSet getInformation() {
        return this.info_;
    }

    public UcarimaModel getUcarimaModel() {
        return this.decomposition;
    }

    public SeatsModel getModel() {
        return this.model;
    }

    public ISeriesDecomposition getComponents() {
        return this.initialComponents;
    }

    public WienerKolmogorovEstimators getWienerKolmogorovEstimators() {
        if (this.decomposition == null) {
            return null;
        }
        if (this.wk_ == null) {
            this.wk_ = new WienerKolmogorovEstimators(this.decomposition);
        }
        return this.wk_;
    }

    @Override
    public Map<String, Class> getDictionary() {
        LinkedHashMap<String, Class> map = new LinkedHashMap<String, Class>();
        MAPPING.fillDictionary(null, map, false);
        return map;
    }

    @Override
    public boolean contains(String id) {
        if (MAPPING.contains(id)) {
            return true;
        }
        if (this.info_ != null) {
            if (!id.contains(InformationSet.STRSEP)) {
                return this.info_.deepSearch(id, Object.class) != null;
            }
            return this.info_.search(id, Object.class) != null;
        }
        return false;
    }

    @Override
    public <T> T getData(String id, Class<T> tclass) {
        if (MAPPING.contains(id)) {
            return MAPPING.getData(this, id, tclass);
        }
        if (this.info_ != null) {
            if (!id.contains(InformationSet.STRSEP)) {
                return this.info_.deepSearch(id, tclass);
            }
            return this.info_.search(id, tclass);
        }
        return null;
    }

    @Override
    public <T> Map<String, T> searchAll(String wc, Class<T> tclass) {
        Map<String, T> all = MAPPING.searchAll(this, wc, tclass);
        if (this.info_ != null) {
            List<Information<T>> sel = this.info_.select(wc, tclass);
            for (Information<T> info : sel) {
                all.put(info.name, info.value);
            }
        }
        return all;
    }

    @Override
    public List<ProcessingInformation> getProcessingInformation() {
        return this.log_ == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(this.log_);
    }

    public static void fillDictionary(String prefix, Map<String, Class> map, boolean compact) {
        MAPPING.fillDictionary(prefix, map, compact);
    }

    public static <T> void setMapping(String name, Class<T> tclass, Function<SeatsResults, T> extractor) {
        MAPPING.set(name, tclass, extractor);
    }

    public static InformationMapping<SeatsResults> getMapping() {
        return MAPPING;
    }

    public static <T> void set(String name, Function<SeatsResults, TsData> extractor) {
        MAPPING.set(name, extractor);
    }

    static {
        MAPPING.set("y_lin", source -> source.initialComponents.getSeries(ComponentType.Series, ComponentInformation.Value));
        MAPPING.set("y_lin_f", source -> source.initialComponents.getSeries(ComponentType.Series, ComponentInformation.Forecast));
        MAPPING.set("y_lin_ef", source -> source.initialComponents.getSeries(ComponentType.Series, ComponentInformation.StdevForecast));
        MAPPING.set("t_lin", source -> source.initialComponents.getSeries(ComponentType.Trend, ComponentInformation.Value));
        MAPPING.set("t_lin_f", source -> source.initialComponents.getSeries(ComponentType.Trend, ComponentInformation.Forecast));
        MAPPING.set("t_lin_e", source -> source.initialComponents.getSeries(ComponentType.Trend, ComponentInformation.Stdev));
        MAPPING.set("t_lin_ef", source -> source.initialComponents.getSeries(ComponentType.Trend, ComponentInformation.StdevForecast));
        MAPPING.set("sa_lin", source -> source.initialComponents.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.Value));
        MAPPING.set("sa_lin_f", source -> source.initialComponents.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.Forecast));
        MAPPING.set("sa_lin_e", source -> source.initialComponents.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.Stdev));
        MAPPING.set("sa_lin_ef", source -> source.initialComponents.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.StdevForecast));
        MAPPING.set("s_lin", source -> source.initialComponents.getSeries(ComponentType.Seasonal, ComponentInformation.Value));
        MAPPING.set("s_lin_f", source -> source.initialComponents.getSeries(ComponentType.Seasonal, ComponentInformation.Forecast));
        MAPPING.set("s_lin_e", source -> source.initialComponents.getSeries(ComponentType.Seasonal, ComponentInformation.Stdev));
        MAPPING.set("s_lin_ef", source -> source.initialComponents.getSeries(ComponentType.Seasonal, ComponentInformation.StdevForecast));
        MAPPING.set("i_lin", source -> source.initialComponents.getSeries(ComponentType.Irregular, ComponentInformation.Value));
        MAPPING.set("i_lin_f", source -> source.initialComponents.getSeries(ComponentType.Irregular, ComponentInformation.Forecast));
        MAPPING.set("i_lin_e", source -> source.initialComponents.getSeries(ComponentType.Irregular, ComponentInformation.Stdev));
        MAPPING.set("i_lin_ef", source -> source.initialComponents.getSeries(ComponentType.Irregular, ComponentInformation.StdevForecast));
        MAPPING.set("y_cmp", source -> source.finalComponents.getSeries(ComponentType.Series, ComponentInformation.Value));
        MAPPING.set("y_cmp_f", source -> source.finalComponents.getSeries(ComponentType.Series, ComponentInformation.Forecast));
        MAPPING.set("t_cmp", source -> source.finalComponents.getSeries(ComponentType.Trend, ComponentInformation.Value));
        MAPPING.set("t_cmp_f", source -> source.finalComponents.getSeries(ComponentType.Trend, ComponentInformation.Forecast));
        MAPPING.set("sa_cmp", source -> source.finalComponents.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.Value));
        MAPPING.set("sa_cmp_f", source -> source.finalComponents.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.Forecast));
        MAPPING.set("s_cmp", source -> source.finalComponents.getSeries(ComponentType.Seasonal, ComponentInformation.Value));
        MAPPING.set("s_cmp_f", source -> source.finalComponents.getSeries(ComponentType.Seasonal, ComponentInformation.Forecast));
        MAPPING.set("i_cmp", source -> source.finalComponents.getSeries(ComponentType.Irregular, ComponentInformation.Value));
        MAPPING.set("i_cmp_f", source -> source.finalComponents.getSeries(ComponentType.Irregular, ComponentInformation.Forecast));
        MAPPING.set("i_cmp_e", source -> source.finalComponents.getSeries(ComponentType.Irregular, ComponentInformation.Stdev));
        MAPPING.set("t_cmp_e", source -> source.finalComponents.getSeries(ComponentType.Trend, ComponentInformation.Stdev));
        MAPPING.set("s_cmp_e", source -> source.finalComponents.getSeries(ComponentType.Seasonal, ComponentInformation.Stdev));
        MAPPING.set("sa_cmp_e", source -> source.finalComponents.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.Stdev));
        MAPPING.set("i_cmp_ef", source -> source.finalComponents.getSeries(ComponentType.Irregular, ComponentInformation.StdevForecast));
        MAPPING.set("t_cmp_ef", source -> source.finalComponents.getSeries(ComponentType.Trend, ComponentInformation.StdevForecast));
        MAPPING.set("s_cmp_ef", source -> source.finalComponents.getSeries(ComponentType.Seasonal, ComponentInformation.StdevForecast));
        MAPPING.set("sa_cmp_ef", source -> source.finalComponents.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.StdevForecast));
        MAPPING.set("si_cmp", source -> {
            TsData i = source.finalComponents.getSeries(ComponentType.Irregular, ComponentInformation.Value);
            TsData s = source.finalComponents.getSeries(ComponentType.Seasonal, ComponentInformation.Value);
            if (source.getSeriesDecomposition().getMode().isMultiplicative()) {
                return TsData.multiply(s, i);
            }
            return TsData.add(s, i);
        });
        MAPPING.set("mode", DecompositionMode.class, source -> source.finalComponents.getMode());
        MAPPING.set(SEAS, Boolean.class, source -> !source.decomposition.getComponent(1).isNull());
        MAPPING.set(CUTOFF, Boolean.class, source -> source.model.isCutOff());
        MAPPING.set(CHANGED, Boolean.class, source -> source.model.isChanged());
        MAPPING.setList(AR_ROOT, 1, 3, Complex.class, (source, i) -> {
            Complex[] ar = source.model.getAutoRegressiveRoots();
            if (i > ar.length) {
                return null;
            }
            return ar[i - 1].inv();
        });
        MAPPING.setList(MA_ROOT, 1, 3, Complex.class, (source, i) -> {
            Complex[] ma = source.model.getMovingAverageRoots();
            if (i > ma.length) {
                return null;
            }
            return ma[i - 1].inv();
        });
        MAPPING.set(TVAR_ESTIMATOR, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.diagnostics();
            return diag == null ? null : Double.valueOf(diag.getEstimatorVariance(0));
        });
        MAPPING.set(TVAR_ESTIMATE, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.diagnostics();
            return diag == null ? null : Double.valueOf(diag.getEstimateVariance(0));
        });
        MAPPING.set(TVAR_PVALUE, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.diagnostics();
            return diag == null ? null : Double.valueOf(diag.getPValue(0));
        });
        MAPPING.set(TVAR_ESTIMATOR, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.diagnostics();
            return diag == null ? null : Double.valueOf(diag.getEstimatorVariance(0));
        });
        MAPPING.set(TVAR_ESTIMATE, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.diagnostics();
            return diag == null ? null : Double.valueOf(diag.getEstimateVariance(0));
        });
        MAPPING.set(TVAR_PVALUE, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.diagnostics();
            return diag == null ? null : Double.valueOf(diag.getPValue(0));
        });
        MAPPING.set(TVAR_ESTIMATOR, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.diagnostics();
            return diag == null ? null : Double.valueOf(diag.getEstimatorVariance(0));
        });
        MAPPING.set(TVAR_ESTIMATE, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.diagnostics();
            return diag == null ? null : Double.valueOf(diag.getEstimateVariance(0));
        });
        MAPPING.set(TVAR_PVALUE, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.diagnostics();
            return diag == null ? null : Double.valueOf(diag.getPValue(0));
        });
        MAPPING.set(SAVAR_ESTIMATOR, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.diagnostics();
            return diag == null ? null : Double.valueOf(diag.getEstimatorVariance(1));
        });
        MAPPING.set(SAVAR_ESTIMATE, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.diagnostics();
            return diag == null ? null : Double.valueOf(diag.getEstimateVariance(1));
        });
        MAPPING.set(SAVAR_PVALUE, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.diagnostics();
            return diag == null ? null : Double.valueOf(diag.getPValue(1));
        });
        MAPPING.set(SVAR_ESTIMATOR, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.diagnostics();
            return diag == null ? null : Double.valueOf(diag.getEstimatorVariance(2));
        });
        MAPPING.set(SVAR_ESTIMATE, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.diagnostics();
            return diag == null ? null : Double.valueOf(diag.getEstimateVariance(2));
        });
        MAPPING.set(SVAR_PVALUE, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.diagnostics();
            return diag == null ? null : Double.valueOf(diag.getPValue(2));
        });
        MAPPING.set(IVAR_ESTIMATOR, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.diagnostics();
            return diag == null ? null : Double.valueOf(diag.getEstimatorVariance(3));
        });
        MAPPING.set(IVAR_ESTIMATE, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.diagnostics();
            return diag == null ? null : Double.valueOf(diag.getEstimateVariance(3));
        });
        MAPPING.set(IVAR_PVALUE, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.diagnostics();
            return diag == null ? null : Double.valueOf(diag.getPValue(3));
        });
        MAPPING.set(TSCORR_ESTIMATOR, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.diagnostics();
            return diag == null ? null : Double.valueOf(diag.getEstimatorCrossCorrelation(0, 2));
        });
        MAPPING.set(TSCORR_ESTIMATE, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.diagnostics();
            return diag == null ? null : Double.valueOf(diag.getEstimateCrossCorrelation(0, 2));
        });
        MAPPING.set(TSCORR_PVALUE, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.diagnostics();
            return diag == null ? null : Double.valueOf(diag.getPValue(0, 2));
        });
        MAPPING.set(TICORR_ESTIMATOR, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.diagnostics();
            return diag == null ? null : Double.valueOf(diag.getEstimatorCrossCorrelation(0, 3));
        });
        MAPPING.set(TICORR_ESTIMATE, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.diagnostics();
            return diag == null ? null : Double.valueOf(diag.getEstimateCrossCorrelation(0, 3));
        });
        MAPPING.set(TICORR_PVALUE, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.diagnostics();
            return diag == null ? null : Double.valueOf(diag.getPValue(0, 3));
        });
        MAPPING.set(SICORR_ESTIMATOR, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.diagnostics();
            return diag == null ? null : Double.valueOf(diag.getEstimatorCrossCorrelation(2, 3));
        });
        MAPPING.set(SICORR_ESTIMATE, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.diagnostics();
            return diag == null ? null : Double.valueOf(diag.getEstimateCrossCorrelation(2, 3));
        });
        MAPPING.set(SICORR_PVALUE, Double.class, source -> {
            WienerKolmogorovDiagnostics diag = source.diagnostics();
            return diag == null ? null : Double.valueOf(diag.getPValue(2, 3));
        });
    }
}

