% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_workspace.R
\name{add_sa_item}
\alias{add_sa_item}
\title{Add a seasonally adjust model to a multi-processing}
\usage{
add_sa_item(workspace, multiprocessing, sa_obj, name)
}
\arguments{
\item{workspace}{the workspace to add the seasonally adjust model.}

\item{multiprocessing}{the name or index of the multiprocessing to add the seasonally adjust model.}

\item{sa_obj}{the seasonally adjust object to export.}

\item{name}{The name of the seasonally adjust model in the multiprocessing.
By default the name of the \code{sa_obj} is used.}
}
\description{
Function to add a new seasonally adjust object (class \code{"SA"} or \code{"jSA"}) in a \code{workspace} object.
}
\examples{
\donttest{
dir <- tempdir()
spec_x13 <- x13_spec(spec = "RSA5c", easter.enabled = FALSE)
sa_x13 <- x13(ipi_c_eu[, "FR"], spec = spec_x13)
spec_ts <- tramoseats_spec(spec = "RSA5")
sa_ts <- jtramoseats(ipi_c_eu[, "FR"], spec = spec_ts)

wk <- new_workspace()
new_multiprocessing(wk, "sa1")
add_sa_item(wk, "sa1", sa_x13, "X13")
add_sa_item(wk, "sa1", sa_ts, "TramoSeats")

save_workspace(wk, file.path(dir, "workspace.xml"))
}

}
\seealso{
\code{\link{load_workspace}}, \code{\link{save_workspace}}
}
