/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.modelling.ComponentType;
import ec.tstoolkit.modelling.PreadjustmentVariable;
import ec.tstoolkit.modelling.RegStatus;
import ec.tstoolkit.modelling.TsVariableDescriptor;
import ec.tstoolkit.modelling.Variable;
import ec.tstoolkit.modelling.arima.IModelBuilder;
import ec.tstoolkit.modelling.arima.ModelDescription;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.tramo.ArimaSpec;
import ec.tstoolkit.modelling.arima.tramo.CalendarSpec;
import ec.tstoolkit.modelling.arima.tramo.EasterSpec;
import ec.tstoolkit.modelling.arima.tramo.RegressionSpec;
import ec.tstoolkit.modelling.arima.tramo.TradingDaysSpec;
import ec.tstoolkit.modelling.arima.tramo.TramoException;
import ec.tstoolkit.modelling.arima.tramo.TramoSpecification;
import ec.tstoolkit.modelling.arima.tramo.TransformSpec;
import ec.tstoolkit.sarima.SarimaComponent;
import ec.tstoolkit.timeseries.calendars.IGregorianCalendarProvider;
import ec.tstoolkit.timeseries.calendars.LengthOfPeriodType;
import ec.tstoolkit.timeseries.calendars.TradingDaysType;
import ec.tstoolkit.timeseries.regression.AbstractTsVariableBox;
import ec.tstoolkit.timeseries.regression.DecoratedTsVariable;
import ec.tstoolkit.timeseries.regression.EasterVariable;
import ec.tstoolkit.timeseries.regression.GregorianCalendarVariables;
import ec.tstoolkit.timeseries.regression.IOutlierVariable;
import ec.tstoolkit.timeseries.regression.ITradingDaysVariable;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.regression.InterventionVariable;
import ec.tstoolkit.timeseries.regression.JulianEasterVariable;
import ec.tstoolkit.timeseries.regression.LeapYearVariable;
import ec.tstoolkit.timeseries.regression.OutlierDefinition;
import ec.tstoolkit.timeseries.regression.Ramp;
import ec.tstoolkit.timeseries.regression.StockTradingDaysVariables;
import ec.tstoolkit.timeseries.regression.TsVariableGroup;
import java.util.ArrayList;
import java.util.Map;

public class TramoModelBuilder
implements IModelBuilder {
    private final TramoSpecification spec_;
    private final ProcessingContext context_;

    public TramoModelBuilder(TramoSpecification spec) {
        this.spec_ = spec;
        this.context_ = ProcessingContext.getActiveContext();
    }

    public TramoModelBuilder(TramoSpecification spec, ProcessingContext context) {
        this.spec_ = spec;
        this.context_ = context != null ? context : ProcessingContext.getActiveContext();
    }

    private void initializeArima(ModelDescription model) {
        boolean yearly;
        boolean bl = yearly = model.getFrequency() == 1;
        if (this.spec_.isUsingAutoModel()) {
            model.setAirline(!yearly);
            model.setMean(true);
        } else if (this.spec_.getArima() == null) {
            model.setAirline(!yearly);
        } else {
            ArimaSpec arima = this.spec_.getArima();
            SarimaComponent cmp = new SarimaComponent(model.getFrequency());
            cmp.setMu(arima.getMu());
            cmp.setPhi(arima.getPhi());
            cmp.setTheta(arima.getTheta());
            cmp.setD(arima.getD());
            if (!yearly) {
                cmp.setBPhi(arima.getBPhi());
                cmp.setBTheta(arima.getBTheta());
                cmp.setBD(arima.getBD());
            }
            model.setArimaComponent(cmp);
        }
    }

    private void initializeVariables(ModelDescription model, RegressionSpec regSpec) {
        if (!regSpec.isUsed()) {
            return;
        }
        Map<String, double[]> preadjustment = regSpec.getAllFixedCoefficients();
        this.initializeCalendar(model, regSpec.getCalendar(), preadjustment);
        if (regSpec.getOutliersCount() > 0) {
            this.initializeOutliers(model, regSpec.getOutliers(), preadjustment);
        }
        if (regSpec.getUserDefinedVariablesCount() > 0) {
            this.initializeUsers(model, regSpec.getUserDefinedVariables(), preadjustment);
        }
        if (regSpec.getInterventionVariablesCount() > 0) {
            this.initializeInterventions(model, regSpec.getInterventionVariables(), preadjustment);
        }
        if (regSpec.getRampsCount() > 0) {
            this.initializeRamps(model, regSpec.getRamps(), preadjustment);
        }
    }

    @Override
    public boolean initialize(ModellingContext context) {
        this.initializeTransformation(context.description, this.spec_.getTransform());
        this.initializeArima(context.description);
        this.initializeVariables(context.description, this.spec_.getRegression());
        return true;
    }

    private void initializeTransformation(ModelDescription model, TransformSpec fnSpec) {
        if (fnSpec == null) {
            return;
        }
        model.setTransformation(fnSpec.getFunction());
    }

    private void initializeCalendar(ModelDescription model, CalendarSpec calendar, Map<String, double[]> preadjustment) {
        if (calendar == null) {
            return;
        }
        this.initializeTradingDays(model, calendar.getTradingDays(), preadjustment);
        this.initializeEaster(model, calendar.getEaster(), preadjustment);
    }

    private void initializeTradingDays(ModelDescription model, TradingDaysSpec td, Map<String, double[]> preadjustment) {
        if (!td.isUsed()) {
            return;
        }
        if (td.isStockTradingDays()) {
            this.initializeStockTradingDays(model, td, preadjustment);
        } else if (td.getHolidays() != null) {
            this.initializeHolidays(model, td, preadjustment);
        } else if (td.getUserVariables() != null) {
            this.initializeUserHolidays(model, td, preadjustment);
        } else if (td.isUsed()) {
            this.initializeDefaultTradingDays(model, td, preadjustment);
        }
    }

    private void initializeEaster(ModelDescription model, EasterSpec easter, Map<String, double[]> preadjustment) {
        if (!easter.isUsed() || model.getFrequency() < 4) {
            return;
        }
        if (easter.isJulian()) {
            JulianEasterVariable var = new JulianEasterVariable();
            var.setDuration(easter.getDuration());
            String sname = ITsVariable.shortName(var.getName());
            if (preadjustment.containsKey(sname)) {
                PreadjustmentVariable pvar = PreadjustmentVariable.movingHolidayVariable(var, preadjustment.get(sname));
                model.addPreadjustment(pvar);
            } else {
                Variable evar = Variable.movingHolidayVariable(var, easter.isTest() ? RegStatus.ToRemove : RegStatus.Prespecified);
                model.addVariable(evar);
            }
        } else {
            EasterVariable var = new EasterVariable();
            var.setDuration(easter.getDuration());
            var.setType(EasterVariable.Correction.Simple);
            var.includeEaster(easter.getOption().containsEaster());
            var.includeEasterMonday(easter.getOption().containsEasterMonday());
            String sname = ITsVariable.shortName(var.getName());
            if (preadjustment.containsKey(sname)) {
                PreadjustmentVariable pvar = PreadjustmentVariable.movingHolidayVariable(var, preadjustment.get(sname));
                model.addPreadjustment(pvar);
            } else {
                Variable evar = Variable.movingHolidayVariable(var, easter.isTest() ? RegStatus.ToRemove : RegStatus.Prespecified);
                model.addVariable(evar);
            }
        }
    }

    private void initializeOutliers(ModelDescription model, OutlierDefinition[] outliers, Map<String, double[]> preadjustment) {
        ArrayList<IOutlierVariable> pvar = new ArrayList<IOutlierVariable>();
        for (int i = 0; i < outliers.length; ++i) {
            IOutlierVariable v = TramoSpecification.getOutliersFactory().make(outliers[i]);
            String sname = ITsVariable.shortName(v.getName());
            if (preadjustment.containsKey(sname)) {
                PreadjustmentVariable pv = PreadjustmentVariable.outlier(v, preadjustment.get(sname));
                model.addPreadjustment(pv);
                continue;
            }
            pvar.add(v);
        }
        model.addPrespecifiedOutliers(pvar);
    }

    private void initializeUsers(ModelDescription model, TsVariableDescriptor[] uvars, Map<String, double[]> preadjustment) {
        if (uvars == null) {
            return;
        }
        for (int i = 0; i < uvars.length; ++i) {
            ITsVariable var = uvars[i].toTsVariable(this.context_);
            String sname = ITsVariable.shortName(var.getName());
            if (preadjustment.containsKey(sname)) {
                PreadjustmentVariable pv = PreadjustmentVariable.userVariable(var, uvars[i].getEffect().type(), preadjustment.get(sname));
                model.addPreadjustment(pv);
                continue;
            }
            Variable uvar = Variable.userVariable(var, uvars[i].getEffect().type(), RegStatus.Prespecified);
            model.addVariable(uvar);
        }
    }

    private void initializeInterventions(ModelDescription model, InterventionVariable[] interventionVariables, Map<String, double[]> preadjustment) {
        if (interventionVariables == null) {
            return;
        }
        for (int i = 0; i < interventionVariables.length; ++i) {
            InterventionVariable var = interventionVariables[i];
            String sname = ITsVariable.shortName(var.getName());
            if (preadjustment.containsKey(sname)) {
                PreadjustmentVariable pv = PreadjustmentVariable.userVariable(var, Variable.searchType(var), preadjustment.get(sname));
                model.addPreadjustment(pv);
                continue;
            }
            Variable uvar = Variable.userVariable(var, Variable.searchType(var), RegStatus.Prespecified);
            model.addVariable(uvar);
        }
    }

    private void initializeRamps(ModelDescription model, Ramp[] ramps, Map<String, double[]> preadjustment) {
        if (ramps == null) {
            return;
        }
        for (int i = 0; i < ramps.length; ++i) {
            Ramp var = ramps[i];
            String sname = ITsVariable.shortName(var.getName());
            if (preadjustment.containsKey(sname)) {
                PreadjustmentVariable pv = PreadjustmentVariable.userVariable(var, ComponentType.Trend, preadjustment.get(sname));
                model.addPreadjustment(pv);
                continue;
            }
            Variable uvar = Variable.userVariable(var, ComponentType.Trend, RegStatus.Prespecified);
            model.addVariable(uvar);
        }
    }

    private void initializeHolidays(ModelDescription model, TradingDaysSpec td, Map<String, double[]> preadjustment) {
        PreadjustmentVariable pvar;
        String sname;
        IGregorianCalendarProvider cal = (IGregorianCalendarProvider)this.context_.getGregorianCalendars().get(td.getHolidays());
        if (cal == null) {
            return;
        }
        TradingDaysType tdType = td.getTradingDaysType();
        if (tdType != TradingDaysType.None) {
            GregorianCalendarVariables var = new GregorianCalendarVariables(cal, tdType);
            sname = ITsVariable.shortName(var.getName());
            if (preadjustment.containsKey(sname)) {
                pvar = PreadjustmentVariable.calendarVariable(var, preadjustment.get(sname));
                model.addPreadjustment(pvar);
            } else {
                Variable tvar = Variable.calendarVariable(var, td.isTest() ? RegStatus.ToRemove : RegStatus.Prespecified);
                model.addVariable(tvar);
            }
        }
        if (td.isLeapYear()) {
            LeapYearVariable lp = new LeapYearVariable(LengthOfPeriodType.LeapYear);
            sname = ITsVariable.shortName(lp.getName());
            if (preadjustment.containsKey(sname)) {
                pvar = PreadjustmentVariable.calendarVariable(lp, preadjustment.get(sname));
                model.addPreadjustment(pvar);
            } else {
                Variable lvar = Variable.calendarVariable(lp, td.isTest() ? RegStatus.ToRemove : RegStatus.Prespecified);
                model.addVariable(lvar);
            }
        }
    }

    private void initializeUserHolidays(ModelDescription model, TradingDaysSpec td, Map<String, double[]> preadjustment) {
        String[] userVariables = td.getUserVariables();
        if (userVariables == null || userVariables.length == 0) {
            return;
        }
        ArrayList<ITsVariable> nonUserFixedVariables = new ArrayList<ITsVariable>();
        for (int i = 0; i < userVariables.length; ++i) {
            userVariables[i] = userVariables[i].replace("td|", "");
            String userVariableName = "td|".concat(userVariables[i]);
            ITsVariable var = this.context_.getTsVariable(userVariables[i]);
            if (var == null) {
                throw new TramoException(userVariables[i] + " not found");
            }
            if (preadjustment.containsKey(ITsVariable.validName(userVariableName))) {
                userVariables[i] = userVariableName;
                DecoratedTsVariable temp = new DecoratedTsVariable(var, userVariableName);
                PreadjustmentVariable pvar = PreadjustmentVariable.tdVariable(temp, preadjustment.get(ITsVariable.validName(userVariables[i])));
                model.addPreadjustment(pvar);
                continue;
            }
            nonUserFixedVariables.add(var);
        }
        if (!nonUserFixedVariables.isEmpty()) {
            TsVariableGroup var = new TsVariableGroup("User-defined calendar variables", nonUserFixedVariables.toArray(new ITsVariable[nonUserFixedVariables.size()]));
            var.setName("usertd");
            if (preadjustment.containsKey("td")) {
                ITradingDaysVariable tdvar_fixed = AbstractTsVariableBox.tradingDays(var);
                PreadjustmentVariable pv_td = PreadjustmentVariable.tdVariable(tdvar_fixed, preadjustment.get("td"));
                model.addPreadjustment(pv_td);
            } else {
                ITradingDaysVariable tdvar = AbstractTsVariableBox.tradingDays(var);
                Variable tvar = Variable.calendarVariable(tdvar, td.isTest() ? RegStatus.ToRemove : RegStatus.Prespecified);
                model.addVariable(tvar);
            }
        }
    }

    private void initializeDefaultTradingDays(ModelDescription model, TradingDaysSpec td, Map<String, double[]> preadjustment) {
        PreadjustmentVariable pvar;
        String sname;
        TradingDaysType tdType = td.getTradingDaysType();
        if (tdType != TradingDaysType.None) {
            GregorianCalendarVariables var = GregorianCalendarVariables.getDefault(tdType);
            sname = ITsVariable.shortName(var.getName());
            if (preadjustment.containsKey(sname)) {
                pvar = PreadjustmentVariable.calendarVariable(var, preadjustment.get(sname));
                model.addPreadjustment(pvar);
            } else {
                Variable tvar = Variable.calendarVariable(var, td.isTest() ? RegStatus.ToRemove : RegStatus.Prespecified);
                model.addVariable(tvar);
            }
        }
        if (td.isLeapYear()) {
            LeapYearVariable lp = new LeapYearVariable(LengthOfPeriodType.LeapYear);
            sname = ITsVariable.shortName(lp.getName());
            if (preadjustment.containsKey(sname)) {
                pvar = PreadjustmentVariable.calendarVariable(lp, preadjustment.get(sname));
                model.addPreadjustment(pvar);
            } else {
                Variable lvar = Variable.calendarVariable(lp, td.isTest() ? RegStatus.ToRemove : RegStatus.Prespecified);
                model.addVariable(lvar);
            }
        }
    }

    private void initializeStockTradingDays(ModelDescription model, TradingDaysSpec td, Map<String, double[]> preadjustment) {
        StockTradingDaysVariables var = new StockTradingDaysVariables(td.getStockTradingDays());
        String sname = ITsVariable.shortName(var.getName());
        if (preadjustment.containsKey(sname)) {
            PreadjustmentVariable pvar = PreadjustmentVariable.calendarVariable(var, preadjustment.get(sname));
            model.addPreadjustment(pvar);
        } else {
            Variable tvar = Variable.calendarVariable(var, td.isTest() ? RegStatus.ToRemove : RegStatus.Prespecified);
            model.addVariable(tvar);
        }
    }
}

