/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.algorithm;

import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.ProcUtilities;
import ec.tstoolkit.algorithm.ProcessingInformation;
import ec.tstoolkit.information.InformationSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CompositeResults
implements IProcResults {
    private final LinkedHashMap<String, Node> nodes = new LinkedHashMap();
    private final List<ProcessingInformation> infos = new ArrayList<ProcessingInformation>();

    public boolean isSuccessful() {
        return !ProcessingInformation.hasErrors(this.infos);
    }

    public void put(String name, IProcResults rslts, String prefix) {
        this.nodes.put(name, new Node(rslts, prefix));
    }

    public void remove(String name) {
        this.nodes.remove(name);
    }

    public void removeAll() {
        this.nodes.clear();
    }

    public int getNodesCount() {
        return this.nodes.size();
    }

    public Node getNode(String name) {
        return this.nodes.get(name);
    }

    public <R extends IProcResults> R get(String name, Class<R> rclass) {
        Node node = this.nodes.get(name);
        if (node == null || node.results == null || !rclass.isAssignableFrom(node.results.getClass())) {
            return null;
        }
        return (R)node.results;
    }

    public IProcResults get(String name) {
        Node node = this.nodes.get(name);
        if (node == null) {
            return null;
        }
        return node.results;
    }

    @Override
    public List<ProcessingInformation> getProcessingInformation() {
        return Collections.unmodifiableList(this.infos);
    }

    public void addInformation(ProcessingInformation info) {
        this.infos.add(info);
    }

    public void addInformation(List<ProcessingInformation> info) {
        this.infos.addAll(info);
    }

    @Override
    public boolean contains(String id) {
        for (Node node : this.nodes.values()) {
            if (node.results == null) continue;
            String cid = null;
            cid = node.prefix != null && InformationSet.isPrefix(id, node.prefix) ? InformationSet.removePrefix(id) : id;
            if (cid == null || !node.results.contains(cid)) continue;
            return true;
        }
        for (Map.Entry entry : this.nodes.entrySet()) {
            String cid;
            Node node = (Node)entry.getValue();
            if (node.results == null || (cid = node.prefix != null && InformationSet.isPrefix(id, node.prefix) ? InformationSet.removePrefix(id) : id) == null) continue;
            return node.results.contains(cid);
        }
        return false;
    }

    @Override
    public Map<String, Class> getDictionary() {
        LinkedHashMap<String, Class> dic = new LinkedHashMap<String, Class>();
        for (Node node : this.nodes.values()) {
            if (node.results == null) continue;
            Map<String, Class> cur = node.results.getDictionary();
            ProcUtilities.fillDictionary(dic, node.prefix, cur);
        }
        return dic;
    }

    @Override
    public <T> T getData(String id, Class<T> tclass) {
        String cid;
        Node node;
        for (Map.Entry<String, Node> entry : this.nodes.entrySet()) {
            node = entry.getValue();
            if (node.results == null) continue;
            cid = null;
            if (node.prefix != null) {
                if (InformationSet.isPrefix(id, node.prefix)) {
                    cid = InformationSet.removePrefix(id);
                }
            } else {
                cid = id;
            }
            if (cid == null || !node.results.contains(cid)) continue;
            return node.results.getData(cid, tclass);
        }
        for (Map.Entry<String, Node> entry : this.nodes.entrySet()) {
            node = entry.getValue();
            if (node.results == null || (cid = node.prefix != null && InformationSet.isPrefix(id, node.prefix) ? InformationSet.removePrefix(id) : id) == null || !node.results.contains(cid)) continue;
            return node.results.getData(cid, tclass);
        }
        return null;
    }

    @Override
    public <T> Map<String, T> searchAll(String id, Class<T> tclass) {
        Node node;
        LinkedHashMap<String, T> all = new LinkedHashMap<String, T>();
        for (Map.Entry<String, Node> entry : this.nodes.entrySet()) {
            node = entry.getValue();
            if (node.results == null) continue;
            if (node.prefix != null) {
                if (!InformationSet.isPrefix(id, node.prefix)) continue;
                all.putAll(node.results.searchAll(InformationSet.removePrefix(id), tclass));
                continue;
            }
            all.putAll(node.results.searchAll(id, tclass));
        }
        if (all.isEmpty()) {
            for (Map.Entry<String, Node> entry : this.nodes.entrySet()) {
                node = entry.getValue();
                if (node.results == null) continue;
                String cid = node.prefix != null && InformationSet.isPrefix(id, node.prefix) ? InformationSet.removePrefix(id) : id;
                all.putAll(node.results.searchAll(cid, tclass));
            }
        }
        return all;
    }

    public static <T> T searchData(Map<String, IProcResults> results, String id, Class<T> tclass) {
        for (Map.Entry<String, IProcResults> entry : results.entrySet()) {
            if (entry.getValue() == null || !entry.getValue().contains(id)) continue;
            return entry.getValue().getData(id, tclass);
        }
        return null;
    }

    public static class Node {
        public final IProcResults results;
        public final String prefix;

        public Node(IProcResults results, String prefix) {
            this.results = results;
            this.prefix = prefix;
        }
    }
}

