/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.matrices;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IDataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.matrices.AbstractLinearSystemSolver;
import ec.tstoolkit.maths.matrices.IQrDecomposition;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.MatrixException;
import ec.tstoolkit.maths.matrices.SubMatrix;

public class HouseholderR
extends AbstractLinearSystemSolver
implements IQrDecomposition {
    private double[] qraux_;
    private Matrix m_;
    private int[] pivot_;
    private int n_;
    private int p_;
    private final boolean m_bclone;
    private int rank_;

    public HouseholderR(boolean clone) {
        this.m_bclone = clone;
    }

    @Override
    public void decompose(Matrix m) {
        if (this.m_bclone) {
            this.init(m.clone());
        } else {
            this.init(m);
        }
        this.householder();
    }

    @Override
    public void decompose(SubMatrix m) {
        this.init(new Matrix(m));
        this.householder();
    }

    public int[] getPivot() {
        return this.pivot_;
    }

    public int getRank() {
        return this.rank_;
    }

    private void init(Matrix m) {
        this.m_ = m;
        this.n_ = m.getRowsCount();
        this.p_ = m.getColumnsCount();
        this.pivot_ = new int[this.p_];
        for (int i = 0; i < this.p_; ++i) {
            this.pivot_[i] = i;
        }
        this.qraux_ = new double[this.p_];
    }

    private void householder() {
        double[] tmp1 = new double[this.p_];
        double[] tmp2 = new double[this.p_];
        double[] x = this.m_.data_;
        DataBlock col = new DataBlock(x, 0, this.n_, 1);
        for (int i = 0; i < this.p_; ++i) {
            double nrm;
            this.qraux_[i] = nrm = col.nrm2();
            tmp1[i] = nrm;
            tmp2[i] = nrm == 0.0 ? 1.0 : nrm;
            col.slide(this.n_);
        }
        int lup = Math.min(this.n_, this.p_);
        this.rank_ = this.p_;
        double eps = this.getEpsilon();
        int l = 0;
        int lq = 0;
        while (l < lup) {
            int nl;
            double nrmxl;
            while (l < this.rank_ && this.qraux_[l] < tmp2[l] * eps) {
                int z = this.p_ - 1;
                System.arraycopy(x, (l + 1) * this.n_, x, l * this.n_, (z - l) * this.n_);
                int ip = this.pivot_[l];
                double aux = this.qraux_[l];
                double t1 = tmp1[l];
                double t2 = tmp2[l];
                for (int k = l; k < z; ++k) {
                    this.qraux_[k] = this.qraux_[k + 1];
                    tmp1[k] = tmp1[k + 1];
                    tmp2[k] = tmp2[k + 1];
                    this.pivot_[k] = this.pivot_[k + 1];
                }
                this.qraux_[z] = aux;
                tmp1[z] = t1;
                tmp2[z] = t2;
                this.pivot_[z] = ip;
                --this.rank_;
            }
            if (l != this.n_ - 1 && (nrmxl = DataBlock.create(x, lq, nl = this.n_ - l).nrm2()) != 0.0) {
                double xq = x[lq];
                if (xq < 0.0) {
                    nrmxl = -nrmxl;
                }
                int j = lq;
                while (j < lq + nl) {
                    int n = j++;
                    x[n] = x[n] / nrmxl;
                }
                int n = lq;
                x[n] = x[n] + 1.0;
                j = l + 1;
                int jc = lq + this.n_;
                while (j < this.p_) {
                    double t = 0.0;
                    int k = 0;
                    int iq = lq;
                    int jq = jc;
                    while (k < nl) {
                        t -= x[iq] * x[jq];
                        ++k;
                        ++iq;
                        ++jq;
                    }
                    t /= x[lq];
                    k = 0;
                    iq = lq;
                    jq = jc;
                    while (k < nl) {
                        int n2 = jq++;
                        x[n2] = x[n2] + t * x[iq];
                        ++k;
                        ++iq;
                    }
                    if (this.qraux_[j] != 0.0) {
                        double z = x[jc] / this.qraux_[j];
                        double tt = Math.max(0.0, 1.0 - z * z);
                        if (tt < 1.0E-6) {
                            this.qraux_[j] = DataBlock.create(x, jc + 1, nl - 1).nrm2();
                            tmp1[j] = this.qraux_[j];
                        } else {
                            int n3 = j;
                            this.qraux_[n3] = this.qraux_[n3] * Math.sqrt(tt);
                        }
                    }
                    ++j;
                    jc += this.n_;
                }
                this.qraux_[l] = x[lq];
                x[lq] = -nrmxl;
            }
            ++l;
            lq += this.n_ + 1;
        }
        this.rank_ = Math.min(this.rank_, this.n_);
    }

    private void pivot(double[] external, double[] internal) {
        for (int i = 0; i < external.length; ++i) {
            internal[i] = external[this.pivot_[i]];
        }
    }

    private void restore(double[] external, double[] internal) {
        for (int i = 0; i < external.length; ++i) {
            external[this.pivot_[i]] = internal[i];
        }
    }

    public void applyQt(double[] b) {
        this.applyQt(b, this.rank_);
    }

    public void applyQt(double[] b, int k) {
        double[] x = this.m_.data_;
        int kmax = Math.min(k, this.n_ - 1);
        int j = 0;
        int jj = 0;
        while (j < kmax) {
            if (this.qraux_[j] != 0.0) {
                double a = this.qraux_[j];
                double t = -a * b[j];
                int i = j + 1;
                int l = jj + 1;
                while (i < this.n_) {
                    t -= x[l] * b[i];
                    ++i;
                    ++l;
                }
                int n = j;
                b[n] = b[n] + (t /= a) * a;
                i = j + 1;
                l = jj + 1;
                while (i < this.n_) {
                    int n2 = i++;
                    b[n2] = b[n2] + t * x[l];
                    ++l;
                }
            }
            ++j;
            jj += this.n_ + 1;
        }
    }

    public void applyQ(double[] b) {
        this.applyQ(b, this.rank_);
    }

    public void applyQ(double[] xb, int k) {
        int j;
        double[] b = (double[])xb.clone();
        this.pivot(xb, b);
        double[] x = this.m_.data_;
        int kmax = Math.min(k, this.n_ - 1);
        int jj = j * (this.n_ + 1);
        for (j = kmax - 1; j >= 0; --j) {
            if (this.qraux_[j] != 0.0) {
                double a = this.qraux_[j];
                double t = -a * b[j];
                int i = j + 1;
                int l = jj + 1;
                while (i < this.n_) {
                    t -= x[l] * b[i];
                    ++i;
                    ++l;
                }
                int n = j;
                b[n] = b[n] + (t /= a) * a;
                i = j + 1;
                l = jj + 1;
                while (i < this.n_) {
                    int n2 = i++;
                    b[n2] = b[n2] + t * x[l];
                    ++l;
                }
            }
            jj -= this.n_ + 1;
        }
        this.restore(xb, b);
    }

    @Override
    public void solve(DataBlock xin, DataBlock xout) throws MatrixException {
        this.leastSquares(xin, xout, null);
    }

    @Override
    public double[] solve(double[] x) {
        int rank = this.getRank();
        if (rank != Math.min(this.n_, this.p_)) {
            throw new MatrixException("m_err_sing");
        }
        double[] b = new double[rank];
        this.leastSquares(new DataBlock(x), new DataBlock(b), null);
        return b;
    }

    @Override
    public int getEquationsCount() {
        return this.n_;
    }

    @Override
    public int getUnknownsCount() {
        return this.p_;
    }

    @Override
    public boolean isFullRank() {
        return this.rank_ == Math.min(this.n_, this.p_);
    }

    @Override
    public Matrix getR() {
        double[] x = this.m_.data_;
        int rank = this.getRank();
        Matrix r = new Matrix(rank, rank);
        double[] data = r.data_;
        int i = 0;
        int k = 0;
        int l = 0;
        while (i < rank) {
            for (int j = 0; j <= i; ++j) {
                data[k + j] = x[l + j];
            }
            ++i;
            k += rank;
            l += this.n_;
        }
        return r;
    }

    @Override
    public DataBlock getRDiagonal() {
        return DataBlock.create(this.m_.data_, 0, Math.min(this.n_, this.p_), this.n_ + 1);
    }

    @Override
    public void leastSquares(IReadDataBlock x, IDataBlock b, IDataBlock res) {
        double[] x_ = this.m_.data_;
        double[] y = new double[x.getLength()];
        x.copyTo(y, 0);
        this.applyQt(y, this.rank_);
        if (res != null) {
            res.copyFrom(y, this.rank_);
        }
        double eps = this.getEpsilon() * 1000.0;
        int k = this.rank_ - 1;
        int kk = k * (this.n_ + 1);
        while (k >= 0) {
            int i;
            double xkk = x_[kk];
            if (Math.abs(xkk) > eps) {
                int n = k;
                y[n] = y[n] / xkk;
                for (i = 0; i < k; ++i) {
                    int n2 = i;
                    y[n2] = y[n2] - y[k] * x_[i + k * this.n_];
                }
            } else {
                for (i = 0; i < k; ++i) {
                    double xcur = x_[i + k * this.n_];
                    if (!(Math.abs(xcur) > eps)) continue;
                    throw new MatrixException("m_err_rank");
                }
            }
            --k;
            kk -= this.n_ + 1;
        }
        b.copyFrom(y, 0);
    }

    public void partialLeastSquares(DataBlock x, DataBlock b, DataBlock res) throws MatrixException {
        double[] x_ = this.m_.data_;
        double[] y = new double[x.getLength()];
        x.copyTo(y, 0);
        int rc = b.getLength();
        this.applyQt(y, rc);
        if (res != null) {
            res.copyFrom(y, rc);
        }
        int k = rc - 1;
        int kk = k * (this.n_ + 1);
        while (k >= 0) {
            int n = k;
            y[n] = y[n] / x_[kk];
            for (int i = 0; i < k; ++i) {
                int n2 = i;
                y[n2] = y[n2] - y[k] * x_[i + k * this.n_];
            }
            --k;
            kk -= this.n_ + 1;
        }
        b.copyFrom(y, 0);
    }

    public int rank(int nvars) {
        int rank = this.getRank();
        if (nvars < 0 || nvars >= this.pivot_.length) {
            return rank;
        }
        int n = 0;
        for (int i = 0; i < nvars; ++i) {
            if (this.pivot_[i] >= rank) continue;
            ++n;
        }
        return n;
    }

    public int[] getUnused() {
        int[] n = new int[this.p_ - this.rank_];
        int i = this.rank_;
        int j = 0;
        while (i < this.p_) {
            n[j] = this.pivot_[i];
            ++i;
            ++j;
        }
        return n;
    }
}

