/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries;

import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.DayOfWeek;
import ec.tstoolkit.timeseries.IPeriod;
import ec.tstoolkit.timeseries.Month;
import java.util.Date;

public class Week
implements IPeriod,
Cloneable {
    private int m_d0;

    public static int subtract(Week d0, Week d1) {
        return (d0.m_d0 - d1.m_d0) / 7;
    }

    public Week(Day d0) {
        this.m_d0 = d0.getId();
    }

    public Week(Day day, DayOfWeek start) {
        this.m_d0 = day.getId() - start.intValue();
    }

    Week(int d0) {
        this.m_d0 = d0;
    }

    public Week(int year, int pos) {
        Day day = new Day(year, Month.January, 0);
        int dweek = day.getDayOfWeek().intValue();
        int delta = 0;
        if (dweek != 0) {
            delta = 7 - dweek;
        }
        day = day.plus(delta += 7 * pos);
        this.m_d0 = day.getId();
    }

    public Week(Week w) {
        this.m_d0 = w.m_d0;
    }

    public Object clone() {
        return new Week(this);
    }

    @Override
    public boolean contains(Date dt) {
        int n = new Day(dt).getId() - this.m_d0;
        return n >= 0 && n <= 6;
    }

    public boolean contains(Day day) {
        int n = day.getId() - this.m_d0;
        return n >= 0 && n <= 6;
    }

    public int difference(Week w1) {
        return (this.m_d0 - w1.m_d0) / 7;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof Week && this.equals((Week)obj);
    }

    private boolean equals(Week other) {
        return other.m_d0 == this.m_d0;
    }

    @Override
    public Day firstday() {
        return new Day(this.m_d0);
    }

    int getId() {
        return this.m_d0;
    }

    public int hashCode() {
        return this.m_d0;
    }

    @Override
    public Day lastday() {
        return new Day(this.m_d0 + 6);
    }

    public void move(int nWeeks) {
        this.m_d0 += nWeeks * 7;
    }

    public void set(Date start) {
        this.m_d0 = new Day(start).getId();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(32);
        builder.append('[').append(this.firstday().toString()).append('-').append(this.lastday().toString()).append(']');
        return builder.toString();
    }
}

