/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.realfunctions.bfgs;

import ec.tstoolkit.maths.realfunctions.bfgs.ILineFunction;
import ec.tstoolkit.maths.realfunctions.bfgs.ILineSearch;

public class QuadraticLineSearch
implements ILineSearch {
    private ILineFunction m_fn;
    private double m_stpmax;
    private double m_stpopt;
    private double m_fopt;
    private double m_expand = 4.0;
    private double m_d0;
    private double m_f0;
    private double m_eps = 1.0E-15;
    private boolean m_opt = true;
    int m_iter;
    int m_maxiter = 20;
    int m_miniter = 5;

    @Override
    public ILineSearch exemplar() {
        QuadraticLineSearch ls = new QuadraticLineSearch();
        ls.m_expand = this.m_expand;
        ls.m_opt = this.m_opt;
        ls.m_maxiter = this.m_maxiter;
        ls.m_miniter = this.m_miniter;
        return ls;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void expand(double stp) {
        if (!this.m_opt) {
            return;
        }
        try {
            stp *= this.m_expand;
            do {
                if (stp > this.m_stpmax) {
                    return;
                }
                this.m_fn.setStep(stp);
                double f = this.m_fn.getValue();
                if (f > this.m_fopt) {
                    return;
                }
                this.m_fopt = f;
                this.m_stpopt = stp;
                double nstp = this.pmin(stp, f);
                if (nstp < stp) return;
                stp = nstp * this.m_expand;
            } while (this.m_iter++ < this.m_miniter);
            return;
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public boolean optimize(ILineFunction fn, double start) {
        this.m_fn = fn;
        this.m_stpmax = fn.getStepMax();
        if (this.m_stpmax < this.m_eps) {
            return true;
        }
        double stp = start;
        if (stp > this.m_stpmax) {
            stp = this.m_stpmax;
        }
        this.m_d0 = fn.getDerivative();
        this.m_f0 = fn.getValue();
        this.m_stpopt = 0.0;
        this.m_fopt = this.m_f0;
        this.m_iter = 0;
        this.m_fn.setStep(stp);
        double f = this.m_fn.getValue();
        if (!this.quadOK(stp, f)) {
            this.m_stpopt = stp;
            this.m_fopt = f;
            this.expand(stp);
        } else {
            double mstp = this.pmin(stp, f);
            if (mstp >= stp) {
                this.m_stpopt = stp;
                this.m_fopt = f;
                this.expand(stp);
            } else {
                this.shrink(mstp);
            }
        }
        this.m_fn.setStep(this.m_stpopt);
        return this.m_iter < this.m_maxiter;
    }

    private double pmin(double stp, double f) {
        double ds = this.m_d0 * stp;
        double df = f - this.m_f0 - ds;
        return -0.5 * ds * stp / df;
    }

    private boolean quadOK(double stp, double f) {
        double ds = this.m_d0 * stp;
        double df = f - this.m_f0 - ds;
        return df > 0.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void shrink(double stp) {
        try {
            do {
                double nstp;
                this.m_fn.setStep(stp);
                double f = this.m_fn.getValue();
                if (f < this.m_fopt) {
                    this.m_fopt = f;
                    this.m_stpopt = stp;
                    if (this.m_iter > this.m_miniter) {
                        return;
                    }
                } else if (this.m_fopt < this.m_f0) return;
                if ((nstp = this.pmin(stp, f)) > stp) return;
                stp = nstp;
            } while (this.m_iter++ < this.m_maxiter);
            return;
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

