/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima;

import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.arima.StationaryTransformation;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.linearfilters.RationalBackFilter;

public class MovingAverageDistance {
    public static double compute(IArimaModel a, IArimaModel b, int npi) {
        StationaryTransformation sta = a.stationaryTransformation();
        StationaryTransformation stb = b.stationaryTransformation();
        if (!sta.unitRoots.getPolynomial().equals(stb.unitRoots.getPolynomial(), 1.0E-6)) {
            return -1.0;
        }
        RationalBackFilter pia = ((IArimaModel)sta.stationaryModel).getPsiWeights();
        RationalBackFilter pib = ((IArimaModel)stb.stationaryModel).getPsiWeights();
        double[] wa = pia.getWeights(npi + 1);
        double[] wb = pib.getWeights(npi + 1);
        double d = 0.0;
        for (int i = 1; i <= npi; ++i) {
            double di = wa[i] - wb[i];
            d += di * di;
        }
        return Math.sqrt(d);
    }

    public static double compute2(IArimaModel a, IArimaModel b, int npi) {
        BackFilter n;
        double[] c;
        StationaryTransformation sta = a.stationaryTransformation();
        StationaryTransformation stb = b.stationaryTransformation();
        IArimaModel ac = (IArimaModel)sta.stationaryModel;
        IArimaModel bc = (IArimaModel)stb.stationaryModel;
        BackFilter na = ac.getMA();
        BackFilter da = ac.getStationaryAR();
        BackFilter nb = bc.getMA();
        BackFilter db = bc.getStationaryAR();
        BackFilter.SimplifyingTool smp = new BackFilter.SimplifyingTool(true);
        BackFilter ura = sta.unitRoots;
        BackFilter urb = stb.unitRoots;
        if (smp.simplify(ura, urb)) {
            ura = (BackFilter)smp.getLeft();
            urb = (BackFilter)smp.getRight();
        }
        if ((c = (n = na.times(urb).minus(nb.times(ura))).getCoefficients()).length == 1) {
            return 0.0;
        }
        double[] cc = new double[c.length - 1];
        System.arraycopy(c, 1, cc, 0, cc.length);
        n = BackFilter.of(cc);
        if (smp.simplify(n, db)) {
            n = (BackFilter)smp.getLeft();
            db = (BackFilter)smp.getRight();
        }
        RationalBackFilter dpi = new RationalBackFilter(n, da.times(db));
        double[] w = dpi.getWeights(npi);
        double d = 0.0;
        for (int i = 0; i < npi; ++i) {
            double di = w[i];
            d += di * di;
        }
        return Math.sqrt(d);
    }
}

