/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima;

import ec.tstoolkit.modelling.arima.IModelComparator;
import ec.tstoolkit.modelling.arima.ModelEstimation;

public class AICcComparator
implements IModelComparator {
    private final double aicDiff_;

    public AICcComparator() {
        this.aicDiff_ = 0.0;
    }

    public AICcComparator(double aiccDiff) {
        this.aicDiff_ = aiccDiff;
    }

    @Override
    public int compare(ModelEstimation reference, ModelEstimation[] models) {
        int imin = -1;
        double aicc = 0.0;
        for (int i = 0; i < models.length; ++i) {
            if (models[i] == null) continue;
            double aiccCur = models[i].getStatistics().AICC;
            if (imin >= 0 && !(aiccCur < aicc)) continue;
            aicc = aiccCur;
            imin = i;
        }
        if (imin < 0) {
            return -1;
        }
        if (reference == null) {
            return imin;
        }
        double aiccRef = reference.getStatistics().AICC;
        return aiccRef > aicc - this.aicDiff_ ? imin : -1;
    }

    @Override
    public int compare(ModelEstimation reference, ModelEstimation alternative) {
        if (reference == null) {
            return 0;
        }
        if (alternative == null) {
            return -1;
        }
        double aiccRef = reference.getStatistics().AICC;
        double aicc = alternative.getStatistics().AICC;
        return aiccRef + this.aicDiff_ > aicc ? 0 : -1;
    }
}

